<?php
/**
 * SignHashDocument
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swaagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * DocuSign REST API
 *
 * The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.
 *
 * OpenAPI spec version: v2.1
 * Contact: devcenter@docusign.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.4.13-SNAPSHOT
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace DocuSign\eSign\Model;

use \ArrayAccess;
use DocuSign\eSign\ObjectSerializer;

/**
 * SignHashDocument Class Doc Comment
 *
 * @category    Class
 * @package     DocuSign\eSign
 * @author      Swagger Codegen team
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class SignHashDocument implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'signHashDocument';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'data' => '?string',
        'document_id' => '?string',
        'format' => '?string',
        'name' => '?string',
        'remaining_signatures' => 'int',
        'revisions' => '\DocuSign\eSign\Model\Revision[]',
        'signature_properties' => '\DocuSign\eSign\Model\SignatureProperties',
        'signature_type' => '?string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'data' => null,
        'document_id' => null,
        'format' => null,
        'name' => null,
        'remaining_signatures' => 'int64',
        'revisions' => null,
        'signature_properties' => null,
        'signature_type' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'data' => 'data',
        'document_id' => 'documentId',
        'format' => 'format',
        'name' => 'name',
        'remaining_signatures' => 'remainingSignatures',
        'revisions' => 'revisions',
        'signature_properties' => 'signatureProperties',
        'signature_type' => 'signatureType'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'data' => 'setData',
        'document_id' => 'setDocumentId',
        'format' => 'setFormat',
        'name' => 'setName',
        'remaining_signatures' => 'setRemainingSignatures',
        'revisions' => 'setRevisions',
        'signature_properties' => 'setSignatureProperties',
        'signature_type' => 'setSignatureType'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'data' => 'getData',
        'document_id' => 'getDocumentId',
        'format' => 'getFormat',
        'name' => 'getName',
        'remaining_signatures' => 'getRemainingSignatures',
        'revisions' => 'getRevisions',
        'signature_properties' => 'getSignatureProperties',
        'signature_type' => 'getSignatureType'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['data'] = isset($data['data']) ? $data['data'] : null;
        $this->container['document_id'] = isset($data['document_id']) ? $data['document_id'] : null;
        $this->container['format'] = isset($data['format']) ? $data['format'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['remaining_signatures'] = isset($data['remaining_signatures']) ? $data['remaining_signatures'] : null;
        $this->container['revisions'] = isset($data['revisions']) ? $data['revisions'] : null;
        $this->container['signature_properties'] = isset($data['signature_properties']) ? $data['signature_properties'] : null;
        $this->container['signature_type'] = isset($data['signature_type']) ? $data['signature_type'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets data
     *
     * @return ?string
     */
    public function getData()
    {
        return $this->container['data'];
    }

    /**
     * Sets data
     *
     * @param ?string $data 
     *
     * @return $this
     */
    public function setData($data)
    {
        $this->container['data'] = $data;

        return $this;
    }

    /**
     * Gets document_id
     *
     * @return ?string
     */
    public function getDocumentId()
    {
        return $this->container['document_id'];
    }

    /**
     * Sets document_id
     *
     * @param ?string $document_id Specifies the document ID number that the tab is placed on. This must refer to an existing Document's ID attribute.
     *
     * @return $this
     */
    public function setDocumentId($document_id)
    {
        $this->container['document_id'] = $document_id;

        return $this;
    }

    /**
     * Gets format
     *
     * @return ?string
     */
    public function getFormat()
    {
        return $this->container['format'];
    }

    /**
     * Sets format
     *
     * @param ?string $format 
     *
     * @return $this
     */
    public function setFormat($format)
    {
        $this->container['format'] = $format;

        return $this;
    }

    /**
     * Gets name
     *
     * @return ?string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param ?string $name 
     *
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets remaining_signatures
     *
     * @return int
     */
    public function getRemainingSignatures()
    {
        return $this->container['remaining_signatures'];
    }

    /**
     * Sets remaining_signatures
     *
     * @param int $remaining_signatures 
     *
     * @return $this
     */
    public function setRemainingSignatures($remaining_signatures)
    {
        $this->container['remaining_signatures'] = $remaining_signatures;

        return $this;
    }

    /**
     * Gets revisions
     *
     * @return \DocuSign\eSign\Model\Revision[]
     */
    public function getRevisions()
    {
        return $this->container['revisions'];
    }

    /**
     * Sets revisions
     *
     * @param \DocuSign\eSign\Model\Revision[] $revisions 
     *
     * @return $this
     */
    public function setRevisions($revisions)
    {
        $this->container['revisions'] = $revisions;

        return $this;
    }

    /**
     * Gets signature_properties
     *
     * @return \DocuSign\eSign\Model\SignatureProperties
     */
    public function getSignatureProperties()
    {
        return $this->container['signature_properties'];
    }

    /**
     * Sets signature_properties
     *
     * @param \DocuSign\eSign\Model\SignatureProperties $signature_properties signature_properties
     *
     * @return $this
     */
    public function setSignatureProperties($signature_properties)
    {
        $this->container['signature_properties'] = $signature_properties;

        return $this;
    }

    /**
     * Gets signature_type
     *
     * @return ?string
     */
    public function getSignatureType()
    {
        return $this->container['signature_type'];
    }

    /**
     * Sets signature_type
     *
     * @param ?string $signature_type 
     *
     * @return $this
     */
    public function setSignatureType($signature_type)
    {
        $this->container['signature_type'] = $signature_type;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}

