<?php
/**
 * EnvelopeDefinition
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * DocuSign REST API
 *
 * The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.
 *
 * OpenAPI spec version: v2.1
 * Contact: devcenter@docusign.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.4.21
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace DocuSign\eSign\Model;

use \ArrayAccess;
use DocuSign\eSign\ObjectSerializer;

/**
 * EnvelopeDefinition Class Doc Comment
 *
 * @category    Class
 * @description Envelope object definition.
 * @package     DocuSign\eSign
 * @author      Swagger Codegen team <apihelp@docusign.com>
 * @license     The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class EnvelopeDefinition implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'envelopeDefinition';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'access_control_list_base64' => '?string',
        'accessibility' => '?string',
        'allow_comments' => '?string',
        'allow_markup' => '?string',
        'allow_reassign' => '?string',
        'allow_recipient_recursion' => '?string',
        'allow_view_history' => '?string',
        'any_signer' => '?string',
        'asynchronous' => '?string',
        'attachments' => '\DocuSign\eSign\Model\Attachment[]',
        'attachments_uri' => '?string',
        'authoritative_copy' => '?string',
        'authoritative_copy_default' => '?string',
        'auto_navigation' => '?string',
        'brand_id' => '?string',
        'brand_lock' => '?string',
        'burn_default_tab_data' => '?string',
        'certificate_uri' => '?string',
        'completed_date_time' => '?string',
        'composite_templates' => '\DocuSign\eSign\Model\CompositeTemplate[]',
        'copy_recipient_data' => '?string',
        'created_date_time' => '?string',
        'custom_fields' => '\DocuSign\eSign\Model\CustomFields',
        'custom_fields_uri' => '?string',
        'declined_date_time' => '?string',
        'deleted_date_time' => '?string',
        'delivered_date_time' => '?string',
        'disable_responsive_document' => '?string',
        'document_base64' => '?string',
        'documents' => '\DocuSign\eSign\Model\Document[]',
        'documents_combined_uri' => '?string',
        'documents_uri' => '?string',
        'email_blurb' => '?string',
        'email_settings' => '\DocuSign\eSign\Model\EmailSettings',
        'email_subject' => '?string',
        'enable_wet_sign' => '?string',
        'enforce_signer_visibility' => '?string',
        'envelope_attachments' => '\DocuSign\eSign\Model\Attachment[]',
        'envelope_custom_metadata' => '\DocuSign\eSign\Model\EnvelopeCustomMetadata',
        'envelope_documents' => '\DocuSign\eSign\Model\EnvelopeDocument[]',
        'envelope_id' => '?string',
        'envelope_id_stamping' => '?string',
        'envelope_location' => '?string',
        'envelope_metadata' => '\DocuSign\eSign\Model\EnvelopeMetadata',
        'envelope_uri' => '?string',
        'event_notification' => '\DocuSign\eSign\Model\EventNotification',
        'event_notifications' => '\DocuSign\eSign\Model\EventNotification[]',
        'expire_after' => '?string',
        'expire_date_time' => '?string',
        'expire_enabled' => '?string',
        'external_envelope_id' => '?string',
        'folders' => '\DocuSign\eSign\Model\Folder[]',
        'has_comments' => '?string',
        'has_form_data_changed' => '?string',
        'has_wav_file' => '?string',
        'holder' => '?string',
        'initial_sent_date_time' => '?string',
        'is21_cfr_part11' => '?string',
        'is_dynamic_envelope' => '?string',
        'is_signature_provider_envelope' => '?string',
        'last_modified_date_time' => '?string',
        'location' => '?string',
        'lock_information' => '\DocuSign\eSign\Model\LockInformation',
        'message_lock' => '?string',
        'notification' => '\DocuSign\eSign\Model\Notification',
        'notification_uri' => '?string',
        'password' => '?string',
        'power_form' => '\DocuSign\eSign\Model\PowerForm',
        'purge_completed_date' => '?string',
        'purge_request_date' => '?string',
        'purge_state' => '?string',
        'recipients' => '\DocuSign\eSign\Model\Recipients',
        'recipients_lock' => '?string',
        'recipients_uri' => '?string',
        'recipient_view_request' => '\DocuSign\eSign\Model\RecipientViewRequest',
        'sender' => '\DocuSign\eSign\Model\UserInfo',
        'sent_date_time' => '?string',
        'signer_can_sign_on_mobile' => '?string',
        'signing_location' => '?string',
        'status' => '?string',
        'status_changed_date_time' => '?string',
        'status_date_time' => '?string',
        'template_id' => '?string',
        'template_roles' => '\DocuSign\eSign\Model\TemplateRole[]',
        'templates_uri' => '?string',
        'transaction_id' => '?string',
        'use_disclosure' => '?string',
        'voided_date_time' => '?string',
        'voided_reason' => '?string',
        'workflow' => '\DocuSign\eSign\Model\Workflow'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'access_control_list_base64' => null,
        'accessibility' => null,
        'allow_comments' => null,
        'allow_markup' => null,
        'allow_reassign' => null,
        'allow_recipient_recursion' => null,
        'allow_view_history' => null,
        'any_signer' => null,
        'asynchronous' => null,
        'attachments' => null,
        'attachments_uri' => null,
        'authoritative_copy' => null,
        'authoritative_copy_default' => null,
        'auto_navigation' => null,
        'brand_id' => null,
        'brand_lock' => null,
        'burn_default_tab_data' => null,
        'certificate_uri' => null,
        'completed_date_time' => null,
        'composite_templates' => null,
        'copy_recipient_data' => null,
        'created_date_time' => null,
        'custom_fields' => null,
        'custom_fields_uri' => null,
        'declined_date_time' => null,
        'deleted_date_time' => null,
        'delivered_date_time' => null,
        'disable_responsive_document' => null,
        'document_base64' => null,
        'documents' => null,
        'documents_combined_uri' => null,
        'documents_uri' => null,
        'email_blurb' => null,
        'email_settings' => null,
        'email_subject' => null,
        'enable_wet_sign' => null,
        'enforce_signer_visibility' => null,
        'envelope_attachments' => null,
        'envelope_custom_metadata' => null,
        'envelope_documents' => null,
        'envelope_id' => null,
        'envelope_id_stamping' => null,
        'envelope_location' => null,
        'envelope_metadata' => null,
        'envelope_uri' => null,
        'event_notification' => null,
        'event_notifications' => null,
        'expire_after' => null,
        'expire_date_time' => null,
        'expire_enabled' => null,
        'external_envelope_id' => null,
        'folders' => null,
        'has_comments' => null,
        'has_form_data_changed' => null,
        'has_wav_file' => null,
        'holder' => null,
        'initial_sent_date_time' => null,
        'is21_cfr_part11' => null,
        'is_dynamic_envelope' => null,
        'is_signature_provider_envelope' => null,
        'last_modified_date_time' => null,
        'location' => null,
        'lock_information' => null,
        'message_lock' => null,
        'notification' => null,
        'notification_uri' => null,
        'password' => null,
        'power_form' => null,
        'purge_completed_date' => null,
        'purge_request_date' => null,
        'purge_state' => null,
        'recipients' => null,
        'recipients_lock' => null,
        'recipients_uri' => null,
        'recipient_view_request' => null,
        'sender' => null,
        'sent_date_time' => null,
        'signer_can_sign_on_mobile' => null,
        'signing_location' => null,
        'status' => null,
        'status_changed_date_time' => null,
        'status_date_time' => null,
        'template_id' => null,
        'template_roles' => null,
        'templates_uri' => null,
        'transaction_id' => null,
        'use_disclosure' => null,
        'voided_date_time' => null,
        'voided_reason' => null,
        'workflow' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'access_control_list_base64' => 'accessControlListBase64',
        'accessibility' => 'accessibility',
        'allow_comments' => 'allowComments',
        'allow_markup' => 'allowMarkup',
        'allow_reassign' => 'allowReassign',
        'allow_recipient_recursion' => 'allowRecipientRecursion',
        'allow_view_history' => 'allowViewHistory',
        'any_signer' => 'anySigner',
        'asynchronous' => 'asynchronous',
        'attachments' => 'attachments',
        'attachments_uri' => 'attachmentsUri',
        'authoritative_copy' => 'authoritativeCopy',
        'authoritative_copy_default' => 'authoritativeCopyDefault',
        'auto_navigation' => 'autoNavigation',
        'brand_id' => 'brandId',
        'brand_lock' => 'brandLock',
        'burn_default_tab_data' => 'burnDefaultTabData',
        'certificate_uri' => 'certificateUri',
        'completed_date_time' => 'completedDateTime',
        'composite_templates' => 'compositeTemplates',
        'copy_recipient_data' => 'copyRecipientData',
        'created_date_time' => 'createdDateTime',
        'custom_fields' => 'customFields',
        'custom_fields_uri' => 'customFieldsUri',
        'declined_date_time' => 'declinedDateTime',
        'deleted_date_time' => 'deletedDateTime',
        'delivered_date_time' => 'deliveredDateTime',
        'disable_responsive_document' => 'disableResponsiveDocument',
        'document_base64' => 'documentBase64',
        'documents' => 'documents',
        'documents_combined_uri' => 'documentsCombinedUri',
        'documents_uri' => 'documentsUri',
        'email_blurb' => 'emailBlurb',
        'email_settings' => 'emailSettings',
        'email_subject' => 'emailSubject',
        'enable_wet_sign' => 'enableWetSign',
        'enforce_signer_visibility' => 'enforceSignerVisibility',
        'envelope_attachments' => 'envelopeAttachments',
        'envelope_custom_metadata' => 'envelopeCustomMetadata',
        'envelope_documents' => 'envelopeDocuments',
        'envelope_id' => 'envelopeId',
        'envelope_id_stamping' => 'envelopeIdStamping',
        'envelope_location' => 'envelopeLocation',
        'envelope_metadata' => 'envelopeMetadata',
        'envelope_uri' => 'envelopeUri',
        'event_notification' => 'eventNotification',
        'event_notifications' => 'eventNotifications',
        'expire_after' => 'expireAfter',
        'expire_date_time' => 'expireDateTime',
        'expire_enabled' => 'expireEnabled',
        'external_envelope_id' => 'externalEnvelopeId',
        'folders' => 'folders',
        'has_comments' => 'hasComments',
        'has_form_data_changed' => 'hasFormDataChanged',
        'has_wav_file' => 'hasWavFile',
        'holder' => 'holder',
        'initial_sent_date_time' => 'initialSentDateTime',
        'is21_cfr_part11' => 'is21CFRPart11',
        'is_dynamic_envelope' => 'isDynamicEnvelope',
        'is_signature_provider_envelope' => 'isSignatureProviderEnvelope',
        'last_modified_date_time' => 'lastModifiedDateTime',
        'location' => 'location',
        'lock_information' => 'lockInformation',
        'message_lock' => 'messageLock',
        'notification' => 'notification',
        'notification_uri' => 'notificationUri',
        'password' => 'password',
        'power_form' => 'powerForm',
        'purge_completed_date' => 'purgeCompletedDate',
        'purge_request_date' => 'purgeRequestDate',
        'purge_state' => 'purgeState',
        'recipients' => 'recipients',
        'recipients_lock' => 'recipientsLock',
        'recipients_uri' => 'recipientsUri',
        'recipient_view_request' => 'recipientViewRequest',
        'sender' => 'sender',
        'sent_date_time' => 'sentDateTime',
        'signer_can_sign_on_mobile' => 'signerCanSignOnMobile',
        'signing_location' => 'signingLocation',
        'status' => 'status',
        'status_changed_date_time' => 'statusChangedDateTime',
        'status_date_time' => 'statusDateTime',
        'template_id' => 'templateId',
        'template_roles' => 'templateRoles',
        'templates_uri' => 'templatesUri',
        'transaction_id' => 'transactionId',
        'use_disclosure' => 'useDisclosure',
        'voided_date_time' => 'voidedDateTime',
        'voided_reason' => 'voidedReason',
        'workflow' => 'workflow'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'access_control_list_base64' => 'setAccessControlListBase64',
        'accessibility' => 'setAccessibility',
        'allow_comments' => 'setAllowComments',
        'allow_markup' => 'setAllowMarkup',
        'allow_reassign' => 'setAllowReassign',
        'allow_recipient_recursion' => 'setAllowRecipientRecursion',
        'allow_view_history' => 'setAllowViewHistory',
        'any_signer' => 'setAnySigner',
        'asynchronous' => 'setAsynchronous',
        'attachments' => 'setAttachments',
        'attachments_uri' => 'setAttachmentsUri',
        'authoritative_copy' => 'setAuthoritativeCopy',
        'authoritative_copy_default' => 'setAuthoritativeCopyDefault',
        'auto_navigation' => 'setAutoNavigation',
        'brand_id' => 'setBrandId',
        'brand_lock' => 'setBrandLock',
        'burn_default_tab_data' => 'setBurnDefaultTabData',
        'certificate_uri' => 'setCertificateUri',
        'completed_date_time' => 'setCompletedDateTime',
        'composite_templates' => 'setCompositeTemplates',
        'copy_recipient_data' => 'setCopyRecipientData',
        'created_date_time' => 'setCreatedDateTime',
        'custom_fields' => 'setCustomFields',
        'custom_fields_uri' => 'setCustomFieldsUri',
        'declined_date_time' => 'setDeclinedDateTime',
        'deleted_date_time' => 'setDeletedDateTime',
        'delivered_date_time' => 'setDeliveredDateTime',
        'disable_responsive_document' => 'setDisableResponsiveDocument',
        'document_base64' => 'setDocumentBase64',
        'documents' => 'setDocuments',
        'documents_combined_uri' => 'setDocumentsCombinedUri',
        'documents_uri' => 'setDocumentsUri',
        'email_blurb' => 'setEmailBlurb',
        'email_settings' => 'setEmailSettings',
        'email_subject' => 'setEmailSubject',
        'enable_wet_sign' => 'setEnableWetSign',
        'enforce_signer_visibility' => 'setEnforceSignerVisibility',
        'envelope_attachments' => 'setEnvelopeAttachments',
        'envelope_custom_metadata' => 'setEnvelopeCustomMetadata',
        'envelope_documents' => 'setEnvelopeDocuments',
        'envelope_id' => 'setEnvelopeId',
        'envelope_id_stamping' => 'setEnvelopeIdStamping',
        'envelope_location' => 'setEnvelopeLocation',
        'envelope_metadata' => 'setEnvelopeMetadata',
        'envelope_uri' => 'setEnvelopeUri',
        'event_notification' => 'setEventNotification',
        'event_notifications' => 'setEventNotifications',
        'expire_after' => 'setExpireAfter',
        'expire_date_time' => 'setExpireDateTime',
        'expire_enabled' => 'setExpireEnabled',
        'external_envelope_id' => 'setExternalEnvelopeId',
        'folders' => 'setFolders',
        'has_comments' => 'setHasComments',
        'has_form_data_changed' => 'setHasFormDataChanged',
        'has_wav_file' => 'setHasWavFile',
        'holder' => 'setHolder',
        'initial_sent_date_time' => 'setInitialSentDateTime',
        'is21_cfr_part11' => 'setIs21CfrPart11',
        'is_dynamic_envelope' => 'setIsDynamicEnvelope',
        'is_signature_provider_envelope' => 'setIsSignatureProviderEnvelope',
        'last_modified_date_time' => 'setLastModifiedDateTime',
        'location' => 'setLocation',
        'lock_information' => 'setLockInformation',
        'message_lock' => 'setMessageLock',
        'notification' => 'setNotification',
        'notification_uri' => 'setNotificationUri',
        'password' => 'setPassword',
        'power_form' => 'setPowerForm',
        'purge_completed_date' => 'setPurgeCompletedDate',
        'purge_request_date' => 'setPurgeRequestDate',
        'purge_state' => 'setPurgeState',
        'recipients' => 'setRecipients',
        'recipients_lock' => 'setRecipientsLock',
        'recipients_uri' => 'setRecipientsUri',
        'recipient_view_request' => 'setRecipientViewRequest',
        'sender' => 'setSender',
        'sent_date_time' => 'setSentDateTime',
        'signer_can_sign_on_mobile' => 'setSignerCanSignOnMobile',
        'signing_location' => 'setSigningLocation',
        'status' => 'setStatus',
        'status_changed_date_time' => 'setStatusChangedDateTime',
        'status_date_time' => 'setStatusDateTime',
        'template_id' => 'setTemplateId',
        'template_roles' => 'setTemplateRoles',
        'templates_uri' => 'setTemplatesUri',
        'transaction_id' => 'setTransactionId',
        'use_disclosure' => 'setUseDisclosure',
        'voided_date_time' => 'setVoidedDateTime',
        'voided_reason' => 'setVoidedReason',
        'workflow' => 'setWorkflow'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'access_control_list_base64' => 'getAccessControlListBase64',
        'accessibility' => 'getAccessibility',
        'allow_comments' => 'getAllowComments',
        'allow_markup' => 'getAllowMarkup',
        'allow_reassign' => 'getAllowReassign',
        'allow_recipient_recursion' => 'getAllowRecipientRecursion',
        'allow_view_history' => 'getAllowViewHistory',
        'any_signer' => 'getAnySigner',
        'asynchronous' => 'getAsynchronous',
        'attachments' => 'getAttachments',
        'attachments_uri' => 'getAttachmentsUri',
        'authoritative_copy' => 'getAuthoritativeCopy',
        'authoritative_copy_default' => 'getAuthoritativeCopyDefault',
        'auto_navigation' => 'getAutoNavigation',
        'brand_id' => 'getBrandId',
        'brand_lock' => 'getBrandLock',
        'burn_default_tab_data' => 'getBurnDefaultTabData',
        'certificate_uri' => 'getCertificateUri',
        'completed_date_time' => 'getCompletedDateTime',
        'composite_templates' => 'getCompositeTemplates',
        'copy_recipient_data' => 'getCopyRecipientData',
        'created_date_time' => 'getCreatedDateTime',
        'custom_fields' => 'getCustomFields',
        'custom_fields_uri' => 'getCustomFieldsUri',
        'declined_date_time' => 'getDeclinedDateTime',
        'deleted_date_time' => 'getDeletedDateTime',
        'delivered_date_time' => 'getDeliveredDateTime',
        'disable_responsive_document' => 'getDisableResponsiveDocument',
        'document_base64' => 'getDocumentBase64',
        'documents' => 'getDocuments',
        'documents_combined_uri' => 'getDocumentsCombinedUri',
        'documents_uri' => 'getDocumentsUri',
        'email_blurb' => 'getEmailBlurb',
        'email_settings' => 'getEmailSettings',
        'email_subject' => 'getEmailSubject',
        'enable_wet_sign' => 'getEnableWetSign',
        'enforce_signer_visibility' => 'getEnforceSignerVisibility',
        'envelope_attachments' => 'getEnvelopeAttachments',
        'envelope_custom_metadata' => 'getEnvelopeCustomMetadata',
        'envelope_documents' => 'getEnvelopeDocuments',
        'envelope_id' => 'getEnvelopeId',
        'envelope_id_stamping' => 'getEnvelopeIdStamping',
        'envelope_location' => 'getEnvelopeLocation',
        'envelope_metadata' => 'getEnvelopeMetadata',
        'envelope_uri' => 'getEnvelopeUri',
        'event_notification' => 'getEventNotification',
        'event_notifications' => 'getEventNotifications',
        'expire_after' => 'getExpireAfter',
        'expire_date_time' => 'getExpireDateTime',
        'expire_enabled' => 'getExpireEnabled',
        'external_envelope_id' => 'getExternalEnvelopeId',
        'folders' => 'getFolders',
        'has_comments' => 'getHasComments',
        'has_form_data_changed' => 'getHasFormDataChanged',
        'has_wav_file' => 'getHasWavFile',
        'holder' => 'getHolder',
        'initial_sent_date_time' => 'getInitialSentDateTime',
        'is21_cfr_part11' => 'getIs21CfrPart11',
        'is_dynamic_envelope' => 'getIsDynamicEnvelope',
        'is_signature_provider_envelope' => 'getIsSignatureProviderEnvelope',
        'last_modified_date_time' => 'getLastModifiedDateTime',
        'location' => 'getLocation',
        'lock_information' => 'getLockInformation',
        'message_lock' => 'getMessageLock',
        'notification' => 'getNotification',
        'notification_uri' => 'getNotificationUri',
        'password' => 'getPassword',
        'power_form' => 'getPowerForm',
        'purge_completed_date' => 'getPurgeCompletedDate',
        'purge_request_date' => 'getPurgeRequestDate',
        'purge_state' => 'getPurgeState',
        'recipients' => 'getRecipients',
        'recipients_lock' => 'getRecipientsLock',
        'recipients_uri' => 'getRecipientsUri',
        'recipient_view_request' => 'getRecipientViewRequest',
        'sender' => 'getSender',
        'sent_date_time' => 'getSentDateTime',
        'signer_can_sign_on_mobile' => 'getSignerCanSignOnMobile',
        'signing_location' => 'getSigningLocation',
        'status' => 'getStatus',
        'status_changed_date_time' => 'getStatusChangedDateTime',
        'status_date_time' => 'getStatusDateTime',
        'template_id' => 'getTemplateId',
        'template_roles' => 'getTemplateRoles',
        'templates_uri' => 'getTemplatesUri',
        'transaction_id' => 'getTransactionId',
        'use_disclosure' => 'getUseDisclosure',
        'voided_date_time' => 'getVoidedDateTime',
        'voided_reason' => 'getVoidedReason',
        'workflow' => 'getWorkflow'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['access_control_list_base64'] = isset($data['access_control_list_base64']) ? $data['access_control_list_base64'] : null;
        $this->container['accessibility'] = isset($data['accessibility']) ? $data['accessibility'] : null;
        $this->container['allow_comments'] = isset($data['allow_comments']) ? $data['allow_comments'] : null;
        $this->container['allow_markup'] = isset($data['allow_markup']) ? $data['allow_markup'] : null;
        $this->container['allow_reassign'] = isset($data['allow_reassign']) ? $data['allow_reassign'] : null;
        $this->container['allow_recipient_recursion'] = isset($data['allow_recipient_recursion']) ? $data['allow_recipient_recursion'] : null;
        $this->container['allow_view_history'] = isset($data['allow_view_history']) ? $data['allow_view_history'] : null;
        $this->container['any_signer'] = isset($data['any_signer']) ? $data['any_signer'] : null;
        $this->container['asynchronous'] = isset($data['asynchronous']) ? $data['asynchronous'] : null;
        $this->container['attachments'] = isset($data['attachments']) ? $data['attachments'] : null;
        $this->container['attachments_uri'] = isset($data['attachments_uri']) ? $data['attachments_uri'] : null;
        $this->container['authoritative_copy'] = isset($data['authoritative_copy']) ? $data['authoritative_copy'] : null;
        $this->container['authoritative_copy_default'] = isset($data['authoritative_copy_default']) ? $data['authoritative_copy_default'] : null;
        $this->container['auto_navigation'] = isset($data['auto_navigation']) ? $data['auto_navigation'] : null;
        $this->container['brand_id'] = isset($data['brand_id']) ? $data['brand_id'] : null;
        $this->container['brand_lock'] = isset($data['brand_lock']) ? $data['brand_lock'] : null;
        $this->container['burn_default_tab_data'] = isset($data['burn_default_tab_data']) ? $data['burn_default_tab_data'] : null;
        $this->container['certificate_uri'] = isset($data['certificate_uri']) ? $data['certificate_uri'] : null;
        $this->container['completed_date_time'] = isset($data['completed_date_time']) ? $data['completed_date_time'] : null;
        $this->container['composite_templates'] = isset($data['composite_templates']) ? $data['composite_templates'] : null;
        $this->container['copy_recipient_data'] = isset($data['copy_recipient_data']) ? $data['copy_recipient_data'] : null;
        $this->container['created_date_time'] = isset($data['created_date_time']) ? $data['created_date_time'] : null;
        $this->container['custom_fields'] = isset($data['custom_fields']) ? $data['custom_fields'] : null;
        $this->container['custom_fields_uri'] = isset($data['custom_fields_uri']) ? $data['custom_fields_uri'] : null;
        $this->container['declined_date_time'] = isset($data['declined_date_time']) ? $data['declined_date_time'] : null;
        $this->container['deleted_date_time'] = isset($data['deleted_date_time']) ? $data['deleted_date_time'] : null;
        $this->container['delivered_date_time'] = isset($data['delivered_date_time']) ? $data['delivered_date_time'] : null;
        $this->container['disable_responsive_document'] = isset($data['disable_responsive_document']) ? $data['disable_responsive_document'] : null;
        $this->container['document_base64'] = isset($data['document_base64']) ? $data['document_base64'] : null;
        $this->container['documents'] = isset($data['documents']) ? $data['documents'] : null;
        $this->container['documents_combined_uri'] = isset($data['documents_combined_uri']) ? $data['documents_combined_uri'] : null;
        $this->container['documents_uri'] = isset($data['documents_uri']) ? $data['documents_uri'] : null;
        $this->container['email_blurb'] = isset($data['email_blurb']) ? $data['email_blurb'] : null;
        $this->container['email_settings'] = isset($data['email_settings']) ? $data['email_settings'] : null;
        $this->container['email_subject'] = isset($data['email_subject']) ? $data['email_subject'] : null;
        $this->container['enable_wet_sign'] = isset($data['enable_wet_sign']) ? $data['enable_wet_sign'] : null;
        $this->container['enforce_signer_visibility'] = isset($data['enforce_signer_visibility']) ? $data['enforce_signer_visibility'] : null;
        $this->container['envelope_attachments'] = isset($data['envelope_attachments']) ? $data['envelope_attachments'] : null;
        $this->container['envelope_custom_metadata'] = isset($data['envelope_custom_metadata']) ? $data['envelope_custom_metadata'] : null;
        $this->container['envelope_documents'] = isset($data['envelope_documents']) ? $data['envelope_documents'] : null;
        $this->container['envelope_id'] = isset($data['envelope_id']) ? $data['envelope_id'] : null;
        $this->container['envelope_id_stamping'] = isset($data['envelope_id_stamping']) ? $data['envelope_id_stamping'] : null;
        $this->container['envelope_location'] = isset($data['envelope_location']) ? $data['envelope_location'] : null;
        $this->container['envelope_metadata'] = isset($data['envelope_metadata']) ? $data['envelope_metadata'] : null;
        $this->container['envelope_uri'] = isset($data['envelope_uri']) ? $data['envelope_uri'] : null;
        $this->container['event_notification'] = isset($data['event_notification']) ? $data['event_notification'] : null;
        $this->container['event_notifications'] = isset($data['event_notifications']) ? $data['event_notifications'] : null;
        $this->container['expire_after'] = isset($data['expire_after']) ? $data['expire_after'] : null;
        $this->container['expire_date_time'] = isset($data['expire_date_time']) ? $data['expire_date_time'] : null;
        $this->container['expire_enabled'] = isset($data['expire_enabled']) ? $data['expire_enabled'] : null;
        $this->container['external_envelope_id'] = isset($data['external_envelope_id']) ? $data['external_envelope_id'] : null;
        $this->container['folders'] = isset($data['folders']) ? $data['folders'] : null;
        $this->container['has_comments'] = isset($data['has_comments']) ? $data['has_comments'] : null;
        $this->container['has_form_data_changed'] = isset($data['has_form_data_changed']) ? $data['has_form_data_changed'] : null;
        $this->container['has_wav_file'] = isset($data['has_wav_file']) ? $data['has_wav_file'] : null;
        $this->container['holder'] = isset($data['holder']) ? $data['holder'] : null;
        $this->container['initial_sent_date_time'] = isset($data['initial_sent_date_time']) ? $data['initial_sent_date_time'] : null;
        $this->container['is21_cfr_part11'] = isset($data['is21_cfr_part11']) ? $data['is21_cfr_part11'] : null;
        $this->container['is_dynamic_envelope'] = isset($data['is_dynamic_envelope']) ? $data['is_dynamic_envelope'] : null;
        $this->container['is_signature_provider_envelope'] = isset($data['is_signature_provider_envelope']) ? $data['is_signature_provider_envelope'] : null;
        $this->container['last_modified_date_time'] = isset($data['last_modified_date_time']) ? $data['last_modified_date_time'] : null;
        $this->container['location'] = isset($data['location']) ? $data['location'] : null;
        $this->container['lock_information'] = isset($data['lock_information']) ? $data['lock_information'] : null;
        $this->container['message_lock'] = isset($data['message_lock']) ? $data['message_lock'] : null;
        $this->container['notification'] = isset($data['notification']) ? $data['notification'] : null;
        $this->container['notification_uri'] = isset($data['notification_uri']) ? $data['notification_uri'] : null;
        $this->container['password'] = isset($data['password']) ? $data['password'] : null;
        $this->container['power_form'] = isset($data['power_form']) ? $data['power_form'] : null;
        $this->container['purge_completed_date'] = isset($data['purge_completed_date']) ? $data['purge_completed_date'] : null;
        $this->container['purge_request_date'] = isset($data['purge_request_date']) ? $data['purge_request_date'] : null;
        $this->container['purge_state'] = isset($data['purge_state']) ? $data['purge_state'] : null;
        $this->container['recipients'] = isset($data['recipients']) ? $data['recipients'] : null;
        $this->container['recipients_lock'] = isset($data['recipients_lock']) ? $data['recipients_lock'] : null;
        $this->container['recipients_uri'] = isset($data['recipients_uri']) ? $data['recipients_uri'] : null;
        $this->container['recipient_view_request'] = isset($data['recipient_view_request']) ? $data['recipient_view_request'] : null;
        $this->container['sender'] = isset($data['sender']) ? $data['sender'] : null;
        $this->container['sent_date_time'] = isset($data['sent_date_time']) ? $data['sent_date_time'] : null;
        $this->container['signer_can_sign_on_mobile'] = isset($data['signer_can_sign_on_mobile']) ? $data['signer_can_sign_on_mobile'] : null;
        $this->container['signing_location'] = isset($data['signing_location']) ? $data['signing_location'] : null;
        $this->container['status'] = isset($data['status']) ? $data['status'] : null;
        $this->container['status_changed_date_time'] = isset($data['status_changed_date_time']) ? $data['status_changed_date_time'] : null;
        $this->container['status_date_time'] = isset($data['status_date_time']) ? $data['status_date_time'] : null;
        $this->container['template_id'] = isset($data['template_id']) ? $data['template_id'] : null;
        $this->container['template_roles'] = isset($data['template_roles']) ? $data['template_roles'] : null;
        $this->container['templates_uri'] = isset($data['templates_uri']) ? $data['templates_uri'] : null;
        $this->container['transaction_id'] = isset($data['transaction_id']) ? $data['transaction_id'] : null;
        $this->container['use_disclosure'] = isset($data['use_disclosure']) ? $data['use_disclosure'] : null;
        $this->container['voided_date_time'] = isset($data['voided_date_time']) ? $data['voided_date_time'] : null;
        $this->container['voided_reason'] = isset($data['voided_reason']) ? $data['voided_reason'] : null;
        $this->container['workflow'] = isset($data['workflow']) ? $data['workflow'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets access_control_list_base64
     *
     * @return ?string
     */
    public function getAccessControlListBase64()
    {
        return $this->container['access_control_list_base64'];
    }

    /**
     * Sets access_control_list_base64
     *
     * @param ?string $access_control_list_base64 
     *
     * @return $this
     */
    public function setAccessControlListBase64($access_control_list_base64)
    {
        $this->container['access_control_list_base64'] = $access_control_list_base64;

        return $this;
    }

    /**
     * Gets accessibility
     *
     * @return ?string
     */
    public function getAccessibility()
    {
        return $this->container['accessibility'];
    }

    /**
     * Sets accessibility
     *
     * @param ?string $accessibility Sets the document reading zones for screen reader applications.  This element can only be used if Document Accessibility is enabled for the account.   ###### Note: This information is currently generated from the DocuSign web console by setting the reading zones when creating a template, exporting the reading zone string information, and adding it here.
     *
     * @return $this
     */
    public function setAccessibility($accessibility)
    {
        $this->container['accessibility'] = $accessibility;

        return $this;
    }

    /**
     * Gets allow_comments
     *
     * @return ?string
     */
    public function getAllowComments()
    {
        return $this->container['allow_comments'];
    }

    /**
     * Sets allow_comments
     *
     * @param ?string $allow_comments 
     *
     * @return $this
     */
    public function setAllowComments($allow_comments)
    {
        $this->container['allow_comments'] = $allow_comments;

        return $this;
    }

    /**
     * Gets allow_markup
     *
     * @return ?string
     */
    public function getAllowMarkup()
    {
        return $this->container['allow_markup'];
    }

    /**
     * Sets allow_markup
     *
     * @param ?string $allow_markup When set to **true**, Document Markup is enabled for envelope. Account must have Document Markup enabled to use this
     *
     * @return $this
     */
    public function setAllowMarkup($allow_markup)
    {
        $this->container['allow_markup'] = $allow_markup;

        return $this;
    }

    /**
     * Gets allow_reassign
     *
     * @return ?string
     */
    public function getAllowReassign()
    {
        return $this->container['allow_reassign'];
    }

    /**
     * Sets allow_reassign
     *
     * @param ?string $allow_reassign When set to **true**, the recipient can redirect an envelope to a more appropriate recipient.
     *
     * @return $this
     */
    public function setAllowReassign($allow_reassign)
    {
        $this->container['allow_reassign'] = $allow_reassign;

        return $this;
    }

    /**
     * Gets allow_recipient_recursion
     *
     * @return ?string
     */
    public function getAllowRecipientRecursion()
    {
        return $this->container['allow_recipient_recursion'];
    }

    /**
     * Sets allow_recipient_recursion
     *
     * @param ?string $allow_recipient_recursion When set to **true**, this enables the Recursive Recipients feature and allows a recipient to appear more than once in the routing order.
     *
     * @return $this
     */
    public function setAllowRecipientRecursion($allow_recipient_recursion)
    {
        $this->container['allow_recipient_recursion'] = $allow_recipient_recursion;

        return $this;
    }

    /**
     * Gets allow_view_history
     *
     * @return ?string
     */
    public function getAllowViewHistory()
    {
        return $this->container['allow_view_history'];
    }

    /**
     * Sets allow_view_history
     *
     * @param ?string $allow_view_history 
     *
     * @return $this
     */
    public function setAllowViewHistory($allow_view_history)
    {
        $this->container['allow_view_history'] = $allow_view_history;

        return $this;
    }

    /**
     * Gets any_signer
     *
     * @return ?string
     */
    public function getAnySigner()
    {
        return $this->container['any_signer'];
    }

    /**
     * Sets any_signer
     *
     * @param ?string $any_signer 
     *
     * @return $this
     */
    public function setAnySigner($any_signer)
    {
        $this->container['any_signer'] = $any_signer;

        return $this;
    }

    /**
     * Gets asynchronous
     *
     * @return ?string
     */
    public function getAsynchronous()
    {
        return $this->container['asynchronous'];
    }

    /**
     * Sets asynchronous
     *
     * @param ?string $asynchronous When set to **true**, the envelope is queued for processing and the value of the `status` property is set to 'Processing'. Additionally, get status calls return 'Processing' until completed.
     *
     * @return $this
     */
    public function setAsynchronous($asynchronous)
    {
        $this->container['asynchronous'] = $asynchronous;

        return $this;
    }

    /**
     * Gets attachments
     *
     * @return \DocuSign\eSign\Model\Attachment[]
     */
    public function getAttachments()
    {
        return $this->container['attachments'];
    }

    /**
     * Sets attachments
     *
     * @param \DocuSign\eSign\Model\Attachment[] $attachments 
     *
     * @return $this
     */
    public function setAttachments($attachments)
    {
        $this->container['attachments'] = $attachments;

        return $this;
    }

    /**
     * Gets attachments_uri
     *
     * @return ?string
     */
    public function getAttachmentsUri()
    {
        return $this->container['attachments_uri'];
    }

    /**
     * Sets attachments_uri
     *
     * @param ?string $attachments_uri 
     *
     * @return $this
     */
    public function setAttachmentsUri($attachments_uri)
    {
        $this->container['attachments_uri'] = $attachments_uri;

        return $this;
    }

    /**
     * Gets authoritative_copy
     *
     * @return ?string
     */
    public function getAuthoritativeCopy()
    {
        return $this->container['authoritative_copy'];
    }

    /**
     * Sets authoritative_copy
     *
     * @param ?string $authoritative_copy Specifies the Authoritative copy feature. If set to true the Authoritative copy feature is enabled.
     *
     * @return $this
     */
    public function setAuthoritativeCopy($authoritative_copy)
    {
        $this->container['authoritative_copy'] = $authoritative_copy;

        return $this;
    }

    /**
     * Gets authoritative_copy_default
     *
     * @return ?string
     */
    public function getAuthoritativeCopyDefault()
    {
        return $this->container['authoritative_copy_default'];
    }

    /**
     * Sets authoritative_copy_default
     *
     * @param ?string $authoritative_copy_default 
     *
     * @return $this
     */
    public function setAuthoritativeCopyDefault($authoritative_copy_default)
    {
        $this->container['authoritative_copy_default'] = $authoritative_copy_default;

        return $this;
    }

    /**
     * Gets auto_navigation
     *
     * @return ?string
     */
    public function getAutoNavigation()
    {
        return $this->container['auto_navigation'];
    }

    /**
     * Sets auto_navigation
     *
     * @param ?string $auto_navigation 
     *
     * @return $this
     */
    public function setAutoNavigation($auto_navigation)
    {
        $this->container['auto_navigation'] = $auto_navigation;

        return $this;
    }

    /**
     * Gets brand_id
     *
     * @return ?string
     */
    public function getBrandId()
    {
        return $this->container['brand_id'];
    }

    /**
     * Sets brand_id
     *
     * @param ?string $brand_id This sets the brand profile format used for the envelope. The value in the string is the brandId associated with the profile. Account branding must be enabled for the account to use this option.
     *
     * @return $this
     */
    public function setBrandId($brand_id)
    {
        $this->container['brand_id'] = $brand_id;

        return $this;
    }

    /**
     * Gets brand_lock
     *
     * @return ?string
     */
    public function getBrandLock()
    {
        return $this->container['brand_lock'];
    }

    /**
     * Sets brand_lock
     *
     * @param ?string $brand_lock 
     *
     * @return $this
     */
    public function setBrandLock($brand_lock)
    {
        $this->container['brand_lock'] = $brand_lock;

        return $this;
    }

    /**
     * Gets burn_default_tab_data
     *
     * @return ?string
     */
    public function getBurnDefaultTabData()
    {
        return $this->container['burn_default_tab_data'];
    }

    /**
     * Sets burn_default_tab_data
     *
     * @param ?string $burn_default_tab_data 
     *
     * @return $this
     */
    public function setBurnDefaultTabData($burn_default_tab_data)
    {
        $this->container['burn_default_tab_data'] = $burn_default_tab_data;

        return $this;
    }

    /**
     * Gets certificate_uri
     *
     * @return ?string
     */
    public function getCertificateUri()
    {
        return $this->container['certificate_uri'];
    }

    /**
     * Sets certificate_uri
     *
     * @param ?string $certificate_uri Retrieves a URI for an endpoint that allows you to easily retrieve certificate information.
     *
     * @return $this
     */
    public function setCertificateUri($certificate_uri)
    {
        $this->container['certificate_uri'] = $certificate_uri;

        return $this;
    }

    /**
     * Gets completed_date_time
     *
     * @return ?string
     */
    public function getCompletedDateTime()
    {
        return $this->container['completed_date_time'];
    }

    /**
     * Sets completed_date_time
     *
     * @param ?string $completed_date_time Specifies the date and time this item was completed.
     *
     * @return $this
     */
    public function setCompletedDateTime($completed_date_time)
    {
        $this->container['completed_date_time'] = $completed_date_time;

        return $this;
    }

    /**
     * Gets composite_templates
     *
     * @return \DocuSign\eSign\Model\CompositeTemplate[]
     */
    public function getCompositeTemplates()
    {
        return $this->container['composite_templates'];
    }

    /**
     * Sets composite_templates
     *
     * @param \DocuSign\eSign\Model\CompositeTemplate[] $composite_templates A complex type that can be added to create envelopes from a combination of DocuSign templates and PDF forms. The basic envelope remains the same, while the Composite Template adds new document and template overlays into the envelope. There can be any number of Composite Template structures in the envelope.
     *
     * @return $this
     */
    public function setCompositeTemplates($composite_templates)
    {
        $this->container['composite_templates'] = $composite_templates;

        return $this;
    }

    /**
     * Gets copy_recipient_data
     *
     * @return ?string
     */
    public function getCopyRecipientData()
    {
        return $this->container['copy_recipient_data'];
    }

    /**
     * Sets copy_recipient_data
     *
     * @param ?string $copy_recipient_data 
     *
     * @return $this
     */
    public function setCopyRecipientData($copy_recipient_data)
    {
        $this->container['copy_recipient_data'] = $copy_recipient_data;

        return $this;
    }

    /**
     * Gets created_date_time
     *
     * @return ?string
     */
    public function getCreatedDateTime()
    {
        return $this->container['created_date_time'];
    }

    /**
     * Sets created_date_time
     *
     * @param ?string $created_date_time Indicates the date and time the item was created.
     *
     * @return $this
     */
    public function setCreatedDateTime($created_date_time)
    {
        $this->container['created_date_time'] = $created_date_time;

        return $this;
    }

    /**
     * Gets custom_fields
     *
     * @return \DocuSign\eSign\Model\CustomFields
     */
    public function getCustomFields()
    {
        return $this->container['custom_fields'];
    }

    /**
     * Sets custom_fields
     *
     * @param \DocuSign\eSign\Model\CustomFields $custom_fields An optional array of strings that allows the sender to provide custom data about the recipient. This information is returned in the envelope status but otherwise not used by DocuSign. Each customField string can be a maximum of 100 characters.
     *
     * @return $this
     */
    public function setCustomFields($custom_fields)
    {
        $this->container['custom_fields'] = $custom_fields;

        return $this;
    }

    /**
     * Gets custom_fields_uri
     *
     * @return ?string
     */
    public function getCustomFieldsUri()
    {
        return $this->container['custom_fields_uri'];
    }

    /**
     * Sets custom_fields_uri
     *
     * @param ?string $custom_fields_uri Contains a URI for an endpoint that you can use to retrieve the custom fields.
     *
     * @return $this
     */
    public function setCustomFieldsUri($custom_fields_uri)
    {
        $this->container['custom_fields_uri'] = $custom_fields_uri;

        return $this;
    }

    /**
     * Gets declined_date_time
     *
     * @return ?string
     */
    public function getDeclinedDateTime()
    {
        return $this->container['declined_date_time'];
    }

    /**
     * Sets declined_date_time
     *
     * @param ?string $declined_date_time The date and time the recipient declined the document.
     *
     * @return $this
     */
    public function setDeclinedDateTime($declined_date_time)
    {
        $this->container['declined_date_time'] = $declined_date_time;

        return $this;
    }

    /**
     * Gets deleted_date_time
     *
     * @return ?string
     */
    public function getDeletedDateTime()
    {
        return $this->container['deleted_date_time'];
    }

    /**
     * Sets deleted_date_time
     *
     * @param ?string $deleted_date_time Specifies the data and time the item was deleted.
     *
     * @return $this
     */
    public function setDeletedDateTime($deleted_date_time)
    {
        $this->container['deleted_date_time'] = $deleted_date_time;

        return $this;
    }

    /**
     * Gets delivered_date_time
     *
     * @return ?string
     */
    public function getDeliveredDateTime()
    {
        return $this->container['delivered_date_time'];
    }

    /**
     * Sets delivered_date_time
     *
     * @param ?string $delivered_date_time Reserved: For DocuSign use only.
     *
     * @return $this
     */
    public function setDeliveredDateTime($delivered_date_time)
    {
        $this->container['delivered_date_time'] = $delivered_date_time;

        return $this;
    }

    /**
     * Gets disable_responsive_document
     *
     * @return ?string
     */
    public function getDisableResponsiveDocument()
    {
        return $this->container['disable_responsive_document'];
    }

    /**
     * Sets disable_responsive_document
     *
     * @param ?string $disable_responsive_document 
     *
     * @return $this
     */
    public function setDisableResponsiveDocument($disable_responsive_document)
    {
        $this->container['disable_responsive_document'] = $disable_responsive_document;

        return $this;
    }

    /**
     * Gets document_base64
     *
     * @return ?string
     */
    public function getDocumentBase64()
    {
        return $this->container['document_base64'];
    }

    /**
     * Sets document_base64
     *
     * @param ?string $document_base64 
     *
     * @return $this
     */
    public function setDocumentBase64($document_base64)
    {
        $this->container['document_base64'] = $document_base64;

        return $this;
    }

    /**
     * Gets documents
     *
     * @return \DocuSign\eSign\Model\Document[]
     */
    public function getDocuments()
    {
        return $this->container['documents'];
    }

    /**
     * Sets documents
     *
     * @param \DocuSign\eSign\Model\Document[] $documents Complex element contains the details on the documents in the envelope.
     *
     * @return $this
     */
    public function setDocuments($documents)
    {
        $this->container['documents'] = $documents;

        return $this;
    }

    /**
     * Gets documents_combined_uri
     *
     * @return ?string
     */
    public function getDocumentsCombinedUri()
    {
        return $this->container['documents_combined_uri'];
    }

    /**
     * Sets documents_combined_uri
     *
     * @param ?string $documents_combined_uri 
     *
     * @return $this
     */
    public function setDocumentsCombinedUri($documents_combined_uri)
    {
        $this->container['documents_combined_uri'] = $documents_combined_uri;

        return $this;
    }

    /**
     * Gets documents_uri
     *
     * @return ?string
     */
    public function getDocumentsUri()
    {
        return $this->container['documents_uri'];
    }

    /**
     * Sets documents_uri
     *
     * @param ?string $documents_uri Contains a URI for an endpoint that you can use to retrieve the documents.
     *
     * @return $this
     */
    public function setDocumentsUri($documents_uri)
    {
        $this->container['documents_uri'] = $documents_uri;

        return $this;
    }

    /**
     * Gets email_blurb
     *
     * @return ?string
     */
    public function getEmailBlurb()
    {
        return $this->container['email_blurb'];
    }

    /**
     * Sets email_blurb
     *
     * @param ?string $email_blurb Optional element. This is the same as the email body. If specified it is included in email body for all envelope recipients. This can be a maximum of 10000 characters
     *
     * @return $this
     */
    public function setEmailBlurb($email_blurb)
    {
        $this->container['email_blurb'] = $email_blurb;

        return $this;
    }

    /**
     * Gets email_settings
     *
     * @return \DocuSign\eSign\Model\EmailSettings
     */
    public function getEmailSettings()
    {
        return $this->container['email_settings'];
    }

    /**
     * Sets email_settings
     *
     * @param \DocuSign\eSign\Model\EmailSettings $email_settings This optional complex element enables the sender to override some envelope email setting information. This can be used to override the Reply To email address and name associated with the envelope, as well as the BCC email addresses to which an envelope is sent. When the `emailSettings` information is used for an envelope, it only applies to that envelope.  **Important Note:** The `emailSettings` information is not returned in the GET method for envelope status. Use GET /email_settings to return information about the emailSettings.
     *
     * @return $this
     */
    public function setEmailSettings($email_settings)
    {
        $this->container['email_settings'] = $email_settings;

        return $this;
    }

    /**
     * Gets email_subject
     *
     * @return ?string
     */
    public function getEmailSubject()
    {
        return $this->container['email_subject'];
    }

    /**
     * Sets email_subject
     *
     * @param ?string $email_subject Specifies the subject of the email that is sent to all recipients.  See [ML:Template Email Subject Merge Fields] for information about adding merge field information to the email subject.
     *
     * @return $this
     */
    public function setEmailSubject($email_subject)
    {
        $this->container['email_subject'] = $email_subject;

        return $this;
    }

    /**
     * Gets enable_wet_sign
     *
     * @return ?string
     */
    public function getEnableWetSign()
    {
        return $this->container['enable_wet_sign'];
    }

    /**
     * Sets enable_wet_sign
     *
     * @param ?string $enable_wet_sign When set to **true**, the signer is allowed to print the document and sign it on paper.
     *
     * @return $this
     */
    public function setEnableWetSign($enable_wet_sign)
    {
        $this->container['enable_wet_sign'] = $enable_wet_sign;

        return $this;
    }

    /**
     * Gets enforce_signer_visibility
     *
     * @return ?string
     */
    public function getEnforceSignerVisibility()
    {
        return $this->container['enforce_signer_visibility'];
    }

    /**
     * Sets enforce_signer_visibility
     *
     * @param ?string $enforce_signer_visibility When set to **true**, documents with tabs can only be viewed by signers that have a tab on that document. Recipients that have an administrative role (Agent, Editor, or Intermediaries) or informational role (Certified Deliveries or Carbon Copies) can always see all the documents in an envelope, unless they are specifically excluded using this setting when an envelope is sent. Documents that do not have tabs are always visible to all recipients, unless they are specifically excluded using this setting when an envelope is sent.  Your account must have Document Visibility enabled to use this.
     *
     * @return $this
     */
    public function setEnforceSignerVisibility($enforce_signer_visibility)
    {
        $this->container['enforce_signer_visibility'] = $enforce_signer_visibility;

        return $this;
    }

    /**
     * Gets envelope_attachments
     *
     * @return \DocuSign\eSign\Model\Attachment[]
     */
    public function getEnvelopeAttachments()
    {
        return $this->container['envelope_attachments'];
    }

    /**
     * Sets envelope_attachments
     *
     * @param \DocuSign\eSign\Model\Attachment[] $envelope_attachments 
     *
     * @return $this
     */
    public function setEnvelopeAttachments($envelope_attachments)
    {
        $this->container['envelope_attachments'] = $envelope_attachments;

        return $this;
    }

    /**
     * Gets envelope_custom_metadata
     *
     * @return \DocuSign\eSign\Model\EnvelopeCustomMetadata
     */
    public function getEnvelopeCustomMetadata()
    {
        return $this->container['envelope_custom_metadata'];
    }

    /**
     * Sets envelope_custom_metadata
     *
     * @param \DocuSign\eSign\Model\EnvelopeCustomMetadata $envelope_custom_metadata 
     *
     * @return $this
     */
    public function setEnvelopeCustomMetadata($envelope_custom_metadata)
    {
        $this->container['envelope_custom_metadata'] = $envelope_custom_metadata;

        return $this;
    }

    /**
     * Gets envelope_documents
     *
     * @return \DocuSign\eSign\Model\EnvelopeDocument[]
     */
    public function getEnvelopeDocuments()
    {
        return $this->container['envelope_documents'];
    }

    /**
     * Sets envelope_documents
     *
     * @param \DocuSign\eSign\Model\EnvelopeDocument[] $envelope_documents 
     *
     * @return $this
     */
    public function setEnvelopeDocuments($envelope_documents)
    {
        $this->container['envelope_documents'] = $envelope_documents;

        return $this;
    }

    /**
     * Gets envelope_id
     *
     * @return ?string
     */
    public function getEnvelopeId()
    {
        return $this->container['envelope_id'];
    }

    /**
     * Sets envelope_id
     *
     * @param ?string $envelope_id The envelope ID of the envelope status that failed to post.
     *
     * @return $this
     */
    public function setEnvelopeId($envelope_id)
    {
        $this->container['envelope_id'] = $envelope_id;

        return $this;
    }

    /**
     * Gets envelope_id_stamping
     *
     * @return ?string
     */
    public function getEnvelopeIdStamping()
    {
        return $this->container['envelope_id_stamping'];
    }

    /**
     * Sets envelope_id_stamping
     *
     * @param ?string $envelope_id_stamping When set to **true**, Envelope ID Stamping is enabled.
     *
     * @return $this
     */
    public function setEnvelopeIdStamping($envelope_id_stamping)
    {
        $this->container['envelope_id_stamping'] = $envelope_id_stamping;

        return $this;
    }

    /**
     * Gets envelope_location
     *
     * @return ?string
     */
    public function getEnvelopeLocation()
    {
        return $this->container['envelope_location'];
    }

    /**
     * Sets envelope_location
     *
     * @param ?string $envelope_location 
     *
     * @return $this
     */
    public function setEnvelopeLocation($envelope_location)
    {
        $this->container['envelope_location'] = $envelope_location;

        return $this;
    }

    /**
     * Gets envelope_metadata
     *
     * @return \DocuSign\eSign\Model\EnvelopeMetadata
     */
    public function getEnvelopeMetadata()
    {
        return $this->container['envelope_metadata'];
    }

    /**
     * Sets envelope_metadata
     *
     * @param \DocuSign\eSign\Model\EnvelopeMetadata $envelope_metadata Metadata about the features that are enabled for the envelope.
     *
     * @return $this
     */
    public function setEnvelopeMetadata($envelope_metadata)
    {
        $this->container['envelope_metadata'] = $envelope_metadata;

        return $this;
    }

    /**
     * Gets envelope_uri
     *
     * @return ?string
     */
    public function getEnvelopeUri()
    {
        return $this->container['envelope_uri'];
    }

    /**
     * Sets envelope_uri
     *
     * @param ?string $envelope_uri Contains a URI for an endpoint that you can use to retrieve the envelope or envelopes.
     *
     * @return $this
     */
    public function setEnvelopeUri($envelope_uri)
    {
        $this->container['envelope_uri'] = $envelope_uri;

        return $this;
    }

    /**
     * Gets event_notification
     *
     * @return \DocuSign\eSign\Model\EventNotification
     */
    public function getEventNotification()
    {
        return $this->container['event_notification'];
    }

    /**
     * Sets event_notification
     *
     * @param \DocuSign\eSign\Model\EventNotification $event_notification This optional object is used to register a webhook that will receive status changes for this envelope.
     *
     * @return $this
     */
    public function setEventNotification($event_notification)
    {
        $this->container['event_notification'] = $event_notification;

        return $this;
    }

    /**
     * Gets event_notifications
     *
     * @return \DocuSign\eSign\Model\EventNotification[]
     */
    public function getEventNotifications()
    {
        return $this->container['event_notifications'];
    }

    /**
     * Sets event_notifications
     *
     * @param \DocuSign\eSign\Model\EventNotification[] $event_notifications 
     *
     * @return $this
     */
    public function setEventNotifications($event_notifications)
    {
        $this->container['event_notifications'] = $event_notifications;

        return $this;
    }

    /**
     * Gets expire_after
     *
     * @return ?string
     */
    public function getExpireAfter()
    {
        return $this->container['expire_after'];
    }

    /**
     * Sets expire_after
     *
     * @param ?string $expire_after 
     *
     * @return $this
     */
    public function setExpireAfter($expire_after)
    {
        $this->container['expire_after'] = $expire_after;

        return $this;
    }

    /**
     * Gets expire_date_time
     *
     * @return ?string
     */
    public function getExpireDateTime()
    {
        return $this->container['expire_date_time'];
    }

    /**
     * Sets expire_date_time
     *
     * @param ?string $expire_date_time 
     *
     * @return $this
     */
    public function setExpireDateTime($expire_date_time)
    {
        $this->container['expire_date_time'] = $expire_date_time;

        return $this;
    }

    /**
     * Gets expire_enabled
     *
     * @return ?string
     */
    public function getExpireEnabled()
    {
        return $this->container['expire_enabled'];
    }

    /**
     * Sets expire_enabled
     *
     * @param ?string $expire_enabled 
     *
     * @return $this
     */
    public function setExpireEnabled($expire_enabled)
    {
        $this->container['expire_enabled'] = $expire_enabled;

        return $this;
    }

    /**
     * Gets external_envelope_id
     *
     * @return ?string
     */
    public function getExternalEnvelopeId()
    {
        return $this->container['external_envelope_id'];
    }

    /**
     * Sets external_envelope_id
     *
     * @param ?string $external_envelope_id 
     *
     * @return $this
     */
    public function setExternalEnvelopeId($external_envelope_id)
    {
        $this->container['external_envelope_id'] = $external_envelope_id;

        return $this;
    }

    /**
     * Gets folders
     *
     * @return \DocuSign\eSign\Model\Folder[]
     */
    public function getFolders()
    {
        return $this->container['folders'];
    }

    /**
     * Sets folders
     *
     * @param \DocuSign\eSign\Model\Folder[] $folders 
     *
     * @return $this
     */
    public function setFolders($folders)
    {
        $this->container['folders'] = $folders;

        return $this;
    }

    /**
     * Gets has_comments
     *
     * @return ?string
     */
    public function getHasComments()
    {
        return $this->container['has_comments'];
    }

    /**
     * Sets has_comments
     *
     * @param ?string $has_comments 
     *
     * @return $this
     */
    public function setHasComments($has_comments)
    {
        $this->container['has_comments'] = $has_comments;

        return $this;
    }

    /**
     * Gets has_form_data_changed
     *
     * @return ?string
     */
    public function getHasFormDataChanged()
    {
        return $this->container['has_form_data_changed'];
    }

    /**
     * Sets has_form_data_changed
     *
     * @param ?string $has_form_data_changed 
     *
     * @return $this
     */
    public function setHasFormDataChanged($has_form_data_changed)
    {
        $this->container['has_form_data_changed'] = $has_form_data_changed;

        return $this;
    }

    /**
     * Gets has_wav_file
     *
     * @return ?string
     */
    public function getHasWavFile()
    {
        return $this->container['has_wav_file'];
    }

    /**
     * Sets has_wav_file
     *
     * @param ?string $has_wav_file 
     *
     * @return $this
     */
    public function setHasWavFile($has_wav_file)
    {
        $this->container['has_wav_file'] = $has_wav_file;

        return $this;
    }

    /**
     * Gets holder
     *
     * @return ?string
     */
    public function getHolder()
    {
        return $this->container['holder'];
    }

    /**
     * Sets holder
     *
     * @param ?string $holder 
     *
     * @return $this
     */
    public function setHolder($holder)
    {
        $this->container['holder'] = $holder;

        return $this;
    }

    /**
     * Gets initial_sent_date_time
     *
     * @return ?string
     */
    public function getInitialSentDateTime()
    {
        return $this->container['initial_sent_date_time'];
    }

    /**
     * Sets initial_sent_date_time
     *
     * @param ?string $initial_sent_date_time 
     *
     * @return $this
     */
    public function setInitialSentDateTime($initial_sent_date_time)
    {
        $this->container['initial_sent_date_time'] = $initial_sent_date_time;

        return $this;
    }

    /**
     * Gets is21_cfr_part11
     *
     * @return ?string
     */
    public function getIs21CfrPart11()
    {
        return $this->container['is21_cfr_part11'];
    }

    /**
     * Sets is21_cfr_part11
     *
     * @param ?string $is21_cfr_part11 When set to **true**, indicates that this module is enabled on the account.
     *
     * @return $this
     */
    public function setIs21CfrPart11($is21_cfr_part11)
    {
        $this->container['is21_cfr_part11'] = $is21_cfr_part11;

        return $this;
    }

    /**
     * Gets is_dynamic_envelope
     *
     * @return ?string
     */
    public function getIsDynamicEnvelope()
    {
        return $this->container['is_dynamic_envelope'];
    }

    /**
     * Sets is_dynamic_envelope
     *
     * @param ?string $is_dynamic_envelope 
     *
     * @return $this
     */
    public function setIsDynamicEnvelope($is_dynamic_envelope)
    {
        $this->container['is_dynamic_envelope'] = $is_dynamic_envelope;

        return $this;
    }

    /**
     * Gets is_signature_provider_envelope
     *
     * @return ?string
     */
    public function getIsSignatureProviderEnvelope()
    {
        return $this->container['is_signature_provider_envelope'];
    }

    /**
     * Sets is_signature_provider_envelope
     *
     * @param ?string $is_signature_provider_envelope 
     *
     * @return $this
     */
    public function setIsSignatureProviderEnvelope($is_signature_provider_envelope)
    {
        $this->container['is_signature_provider_envelope'] = $is_signature_provider_envelope;

        return $this;
    }

    /**
     * Gets last_modified_date_time
     *
     * @return ?string
     */
    public function getLastModifiedDateTime()
    {
        return $this->container['last_modified_date_time'];
    }

    /**
     * Sets last_modified_date_time
     *
     * @param ?string $last_modified_date_time The date and time the item was last modified.
     *
     * @return $this
     */
    public function setLastModifiedDateTime($last_modified_date_time)
    {
        $this->container['last_modified_date_time'] = $last_modified_date_time;

        return $this;
    }

    /**
     * Gets location
     *
     * @return ?string
     */
    public function getLocation()
    {
        return $this->container['location'];
    }

    /**
     * Sets location
     *
     * @param ?string $location 
     *
     * @return $this
     */
    public function setLocation($location)
    {
        $this->container['location'] = $location;

        return $this;
    }

    /**
     * Gets lock_information
     *
     * @return \DocuSign\eSign\Model\LockInformation
     */
    public function getLockInformation()
    {
        return $this->container['lock_information'];
    }

    /**
     * Sets lock_information
     *
     * @param \DocuSign\eSign\Model\LockInformation $lock_information Provides lock information about an envelope that a user has locked.
     *
     * @return $this
     */
    public function setLockInformation($lock_information)
    {
        $this->container['lock_information'] = $lock_information;

        return $this;
    }

    /**
     * Gets message_lock
     *
     * @return ?string
     */
    public function getMessageLock()
    {
        return $this->container['message_lock'];
    }

    /**
     * Sets message_lock
     *
     * @param ?string $message_lock When set to **true**, prevents senders from changing the contents of `emailBlurb` and `emailSubject` properties for the envelope.   Additionally, this prevents users from making changes to the contents of `emailBlurb` and `emailSubject` properties when correcting envelopes.   However, if the `messageLock` node is set to true**** and the `emailSubject` property is empty, senders and correctors are able to add a subject to the envelope.
     *
     * @return $this
     */
    public function setMessageLock($message_lock)
    {
        $this->container['message_lock'] = $message_lock;

        return $this;
    }

    /**
     * Gets notification
     *
     * @return \DocuSign\eSign\Model\Notification
     */
    public function getNotification()
    {
        return $this->container['notification'];
    }

    /**
     * Sets notification
     *
     * @param \DocuSign\eSign\Model\Notification $notification An optional complex element that specifies the notification options for the envelope.
     *
     * @return $this
     */
    public function setNotification($notification)
    {
        $this->container['notification'] = $notification;

        return $this;
    }

    /**
     * Gets notification_uri
     *
     * @return ?string
     */
    public function getNotificationUri()
    {
        return $this->container['notification_uri'];
    }

    /**
     * Sets notification_uri
     *
     * @param ?string $notification_uri Contains a URI for an endpoint that you can use to retrieve the notifications.
     *
     * @return $this
     */
    public function setNotificationUri($notification_uri)
    {
        $this->container['notification_uri'] = $notification_uri;

        return $this;
    }

    /**
     * Gets password
     *
     * @return ?string
     */
    public function getPassword()
    {
        return $this->container['password'];
    }

    /**
     * Sets password
     *
     * @param ?string $password 
     *
     * @return $this
     */
    public function setPassword($password)
    {
        $this->container['password'] = $password;

        return $this;
    }

    /**
     * Gets power_form
     *
     * @return \DocuSign\eSign\Model\PowerForm
     */
    public function getPowerForm()
    {
        return $this->container['power_form'];
    }

    /**
     * Sets power_form
     *
     * @param \DocuSign\eSign\Model\PowerForm $power_form Information about any PowerForms that are included in the envelope.
     *
     * @return $this
     */
    public function setPowerForm($power_form)
    {
        $this->container['power_form'] = $power_form;

        return $this;
    }

    /**
     * Gets purge_completed_date
     *
     * @return ?string
     */
    public function getPurgeCompletedDate()
    {
        return $this->container['purge_completed_date'];
    }

    /**
     * Sets purge_completed_date
     *
     * @param ?string $purge_completed_date 
     *
     * @return $this
     */
    public function setPurgeCompletedDate($purge_completed_date)
    {
        $this->container['purge_completed_date'] = $purge_completed_date;

        return $this;
    }

    /**
     * Gets purge_request_date
     *
     * @return ?string
     */
    public function getPurgeRequestDate()
    {
        return $this->container['purge_request_date'];
    }

    /**
     * Sets purge_request_date
     *
     * @param ?string $purge_request_date 
     *
     * @return $this
     */
    public function setPurgeRequestDate($purge_request_date)
    {
        $this->container['purge_request_date'] = $purge_request_date;

        return $this;
    }

    /**
     * Gets purge_state
     *
     * @return ?string
     */
    public function getPurgeState()
    {
        return $this->container['purge_state'];
    }

    /**
     * Sets purge_state
     *
     * @param ?string $purge_state Initiates a purge request. Valid values are: * documents_queued: Places envelope documents in the purge queue. * documents_and_metadata_queued: Places envelope documents and metadata in the purge queue.
     *
     * @return $this
     */
    public function setPurgeState($purge_state)
    {
        $this->container['purge_state'] = $purge_state;

        return $this;
    }

    /**
     * Gets recipients
     *
     * @return \DocuSign\eSign\Model\Recipients
     */
    public function getRecipients()
    {
        return $this->container['recipients'];
    }

    /**
     * Sets recipients
     *
     * @param \DocuSign\eSign\Model\Recipients $recipients An array of powerform recipients.
     *
     * @return $this
     */
    public function setRecipients($recipients)
    {
        $this->container['recipients'] = $recipients;

        return $this;
    }

    /**
     * Gets recipients_lock
     *
     * @return ?string
     */
    public function getRecipientsLock()
    {
        return $this->container['recipients_lock'];
    }

    /**
     * Sets recipients_lock
     *
     * @param ?string $recipients_lock When set to **true**, prevents senders from changing, correcting, or deleting the recipient information for the envelope.
     *
     * @return $this
     */
    public function setRecipientsLock($recipients_lock)
    {
        $this->container['recipients_lock'] = $recipients_lock;

        return $this;
    }

    /**
     * Gets recipients_uri
     *
     * @return ?string
     */
    public function getRecipientsUri()
    {
        return $this->container['recipients_uri'];
    }

    /**
     * Sets recipients_uri
     *
     * @param ?string $recipients_uri Contains a URI for an endpoint that you can use to retrieve the recipients.
     *
     * @return $this
     */
    public function setRecipientsUri($recipients_uri)
    {
        $this->container['recipients_uri'] = $recipients_uri;

        return $this;
    }

    /**
     * Gets recipient_view_request
     *
     * @return \DocuSign\eSign\Model\RecipientViewRequest
     */
    public function getRecipientViewRequest()
    {
        return $this->container['recipient_view_request'];
    }

    /**
     * Sets recipient_view_request
     *
     * @param \DocuSign\eSign\Model\RecipientViewRequest $recipient_view_request 
     *
     * @return $this
     */
    public function setRecipientViewRequest($recipient_view_request)
    {
        $this->container['recipient_view_request'] = $recipient_view_request;

        return $this;
    }

    /**
     * Gets sender
     *
     * @return \DocuSign\eSign\Model\UserInfo
     */
    public function getSender()
    {
        return $this->container['sender'];
    }

    /**
     * Sets sender
     *
     * @param \DocuSign\eSign\Model\UserInfo $sender Information about the sender of the envelope.
     *
     * @return $this
     */
    public function setSender($sender)
    {
        $this->container['sender'] = $sender;

        return $this;
    }

    /**
     * Gets sent_date_time
     *
     * @return ?string
     */
    public function getSentDateTime()
    {
        return $this->container['sent_date_time'];
    }

    /**
     * Sets sent_date_time
     *
     * @param ?string $sent_date_time The date and time the envelope was sent.
     *
     * @return $this
     */
    public function setSentDateTime($sent_date_time)
    {
        $this->container['sent_date_time'] = $sent_date_time;

        return $this;
    }

    /**
     * Gets signer_can_sign_on_mobile
     *
     * @return ?string
     */
    public function getSignerCanSignOnMobile()
    {
        return $this->container['signer_can_sign_on_mobile'];
    }

    /**
     * Sets signer_can_sign_on_mobile
     *
     * @param ?string $signer_can_sign_on_mobile 
     *
     * @return $this
     */
    public function setSignerCanSignOnMobile($signer_can_sign_on_mobile)
    {
        $this->container['signer_can_sign_on_mobile'] = $signer_can_sign_on_mobile;

        return $this;
    }

    /**
     * Gets signing_location
     *
     * @return ?string
     */
    public function getSigningLocation()
    {
        return $this->container['signing_location'];
    }

    /**
     * Sets signing_location
     *
     * @param ?string $signing_location Specifies the physical location where the signing takes place. It can have two enumeration values; InPerson and Online. The default value is Online.
     *
     * @return $this
     */
    public function setSigningLocation($signing_location)
    {
        $this->container['signing_location'] = $signing_location;

        return $this;
    }

    /**
     * Gets status
     *
     * @return ?string
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param ?string $status Indicates the envelope status. Valid values are:  * sent - The envelope is sent to the recipients.  * created - The envelope is saved as a draft and can be modified and sent later.
     *
     * @return $this
     */
    public function setStatus($status)
    {
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets status_changed_date_time
     *
     * @return ?string
     */
    public function getStatusChangedDateTime()
    {
        return $this->container['status_changed_date_time'];
    }

    /**
     * Sets status_changed_date_time
     *
     * @param ?string $status_changed_date_time The data and time the status changed.
     *
     * @return $this
     */
    public function setStatusChangedDateTime($status_changed_date_time)
    {
        $this->container['status_changed_date_time'] = $status_changed_date_time;

        return $this;
    }

    /**
     * Gets status_date_time
     *
     * @return ?string
     */
    public function getStatusDateTime()
    {
        return $this->container['status_date_time'];
    }

    /**
     * Sets status_date_time
     *
     * @param ?string $status_date_time 
     *
     * @return $this
     */
    public function setStatusDateTime($status_date_time)
    {
        $this->container['status_date_time'] = $status_date_time;

        return $this;
    }

    /**
     * Gets template_id
     *
     * @return ?string
     */
    public function getTemplateId()
    {
        return $this->container['template_id'];
    }

    /**
     * Sets template_id
     *
     * @param ?string $template_id The unique identifier of the template. If this is not provided, DocuSign will generate a value.
     *
     * @return $this
     */
    public function setTemplateId($template_id)
    {
        $this->container['template_id'] = $template_id;

        return $this;
    }

    /**
     * Gets template_roles
     *
     * @return \DocuSign\eSign\Model\TemplateRole[]
     */
    public function getTemplateRoles()
    {
        return $this->container['template_roles'];
    }

    /**
     * Sets template_roles
     *
     * @param \DocuSign\eSign\Model\TemplateRole[] $template_roles Specifies the template recipients. Each roleName in the template must have a recipient assigned to it. This is made up elements:  * email - The recipient's email address. * name - The recipient's name. * roleName - The template roleName associated with the recipient. * clientUserId - Optional, this sets if the signer is This specifies if the recipient is embedded or remote. If the clientUserId is not null then the recipient is embedded. Note that if a ClientUserId is used and the account settings SignerMustHaveAccount or SignerMustLoginToSign are true, an error is generated on sending. * defaultRecipient - Optional, When set to **true**, this recipient is the default recipient and any tabs generated by the transformPdfFields option are mapped to this recipient. * routingOrder - This specifies the routing order of the recipient in the envelope. * accessCode - This optional element specifies the access code a recipient has to enter to validate the identity. This can be a maximum of 50 characters. * inPersonSignerName - Optional, if the template role is an in person signer, this is the full legal name of the signer. This can be a maximum of 100 characters. * emailNotification - This is an optional complex element that has a role specific emailSubject, emailBody, and language. It follows the same format as the emailNotification node for Recipients. * tabs - This allows the tab values to be specified for matching to tabs in the template.
     *
     * @return $this
     */
    public function setTemplateRoles($template_roles)
    {
        $this->container['template_roles'] = $template_roles;

        return $this;
    }

    /**
     * Gets templates_uri
     *
     * @return ?string
     */
    public function getTemplatesUri()
    {
        return $this->container['templates_uri'];
    }

    /**
     * Sets templates_uri
     *
     * @param ?string $templates_uri Contains a URI for an endpoint which you can use to retrieve the templates.
     *
     * @return $this
     */
    public function setTemplatesUri($templates_uri)
    {
        $this->container['templates_uri'] = $templates_uri;

        return $this;
    }

    /**
     * Gets transaction_id
     *
     * @return ?string
     */
    public function getTransactionId()
    {
        return $this->container['transaction_id'];
    }

    /**
     * Sets transaction_id
     *
     * @param ?string $transaction_id Used to identify an envelope. The id is a sender-generated value and is valid in the DocuSign system for 7 days. It is recommended that a transaction ID is used for offline signing to ensure that an envelope is not sent multiple times. The `transactionId` property can be used determine an envelope's status (i.e. was it created or not) in cases where the internet connection was lost before the envelope status was returned.
     *
     * @return $this
     */
    public function setTransactionId($transaction_id)
    {
        $this->container['transaction_id'] = $transaction_id;

        return $this;
    }

    /**
     * Gets use_disclosure
     *
     * @return ?string
     */
    public function getUseDisclosure()
    {
        return $this->container['use_disclosure'];
    }

    /**
     * Sets use_disclosure
     *
     * @param ?string $use_disclosure When set to **true**, the disclosure is shown to recipients in accordance with the account's Electronic Record and Signature Disclosure frequency setting. When set to **false**, the Electronic Record and Signature Disclosure is not shown to any envelope recipients.   If the `useDisclosure` property is not set, then the account's normal disclosure setting is used and the value of the `useDisclosure` property is not returned in responses when getting envelope information.
     *
     * @return $this
     */
    public function setUseDisclosure($use_disclosure)
    {
        $this->container['use_disclosure'] = $use_disclosure;

        return $this;
    }

    /**
     * Gets voided_date_time
     *
     * @return ?string
     */
    public function getVoidedDateTime()
    {
        return $this->container['voided_date_time'];
    }

    /**
     * Sets voided_date_time
     *
     * @param ?string $voided_date_time The date and time the envelope or template was voided.
     *
     * @return $this
     */
    public function setVoidedDateTime($voided_date_time)
    {
        $this->container['voided_date_time'] = $voided_date_time;

        return $this;
    }

    /**
     * Gets voided_reason
     *
     * @return ?string
     */
    public function getVoidedReason()
    {
        return $this->container['voided_reason'];
    }

    /**
     * Sets voided_reason
     *
     * @param ?string $voided_reason The reason the envelope or template was voided.
     *
     * @return $this
     */
    public function setVoidedReason($voided_reason)
    {
        $this->container['voided_reason'] = $voided_reason;

        return $this;
    }

    /**
     * Gets workflow
     *
     * @return \DocuSign\eSign\Model\Workflow
     */
    public function getWorkflow()
    {
        return $this->container['workflow'];
    }

    /**
     * Sets workflow
     *
     * @param \DocuSign\eSign\Model\Workflow $workflow Describes the workflow for this envelope.
     *
     * @return $this
     */
    public function setWorkflow($workflow)
    {
        $this->container['workflow'] = $workflow;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}

