<?php
/**
 * Radio
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * DocuSign REST API
 *
 * The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.
 *
 * OpenAPI spec version: v2.1
 * Contact: devcenter@docusign.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.4.21
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace DocuSign\eSign\Model;

use \ArrayAccess;
use DocuSign\eSign\ObjectSerializer;

/**
 * Radio Class Doc Comment
 *
 * @category    Class
 * @description One of the selectable radio buttons in the &#x60;radios&#x60; property of a [&#x60;radioGroup&#x60;](/docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/) tab.
 * @package     DocuSign\eSign
 * @author      Swagger Codegen team <apihelp@docusign.com>
 * @license     The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class Radio implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'radio';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'anchor_allow_white_space_in_characters' => '?string',
        'anchor_allow_white_space_in_characters_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'anchor_case_sensitive' => '?string',
        'anchor_case_sensitive_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'anchor_horizontal_alignment' => '?string',
        'anchor_horizontal_alignment_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'anchor_ignore_if_not_present' => '?string',
        'anchor_ignore_if_not_present_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'anchor_match_whole_word' => '?string',
        'anchor_match_whole_word_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'anchor_string' => '?string',
        'anchor_string_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'anchor_tab_processor_version' => '?string',
        'anchor_tab_processor_version_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'anchor_units' => '?string',
        'anchor_units_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'anchor_x_offset' => '?string',
        'anchor_x_offset_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'anchor_y_offset' => '?string',
        'anchor_y_offset_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'bold' => '?string',
        'bold_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'caption' => '?string',
        'caption_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'error_details' => '\DocuSign\eSign\Model\ErrorDetails',
        'font' => '?string',
        'font_color' => '?string',
        'font_color_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'font_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'font_size' => '?string',
        'font_size_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'italic' => '?string',
        'italic_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'locked' => '?string',
        'locked_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'merge_field_xml' => '?string',
        'page_number' => '?string',
        'page_number_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'required' => '?string',
        'required_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'selected' => '?string',
        'selected_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'status' => '?string',
        'status_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'tab_id' => '?string',
        'tab_id_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'tab_order' => '?string',
        'tab_order_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'underline' => '?string',
        'underline_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'value' => '?string',
        'value_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'x_position' => '?string',
        'x_position_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'y_position' => '?string',
        'y_position_metadata' => '\DocuSign\eSign\Model\PropertyMetadata'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'anchor_allow_white_space_in_characters' => null,
        'anchor_allow_white_space_in_characters_metadata' => null,
        'anchor_case_sensitive' => null,
        'anchor_case_sensitive_metadata' => null,
        'anchor_horizontal_alignment' => null,
        'anchor_horizontal_alignment_metadata' => null,
        'anchor_ignore_if_not_present' => null,
        'anchor_ignore_if_not_present_metadata' => null,
        'anchor_match_whole_word' => null,
        'anchor_match_whole_word_metadata' => null,
        'anchor_string' => null,
        'anchor_string_metadata' => null,
        'anchor_tab_processor_version' => null,
        'anchor_tab_processor_version_metadata' => null,
        'anchor_units' => null,
        'anchor_units_metadata' => null,
        'anchor_x_offset' => null,
        'anchor_x_offset_metadata' => null,
        'anchor_y_offset' => null,
        'anchor_y_offset_metadata' => null,
        'bold' => null,
        'bold_metadata' => null,
        'caption' => null,
        'caption_metadata' => null,
        'error_details' => null,
        'font' => null,
        'font_color' => null,
        'font_color_metadata' => null,
        'font_metadata' => null,
        'font_size' => null,
        'font_size_metadata' => null,
        'italic' => null,
        'italic_metadata' => null,
        'locked' => null,
        'locked_metadata' => null,
        'merge_field_xml' => null,
        'page_number' => null,
        'page_number_metadata' => null,
        'required' => null,
        'required_metadata' => null,
        'selected' => null,
        'selected_metadata' => null,
        'status' => null,
        'status_metadata' => null,
        'tab_id' => null,
        'tab_id_metadata' => null,
        'tab_order' => null,
        'tab_order_metadata' => null,
        'underline' => null,
        'underline_metadata' => null,
        'value' => null,
        'value_metadata' => null,
        'x_position' => null,
        'x_position_metadata' => null,
        'y_position' => null,
        'y_position_metadata' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'anchor_allow_white_space_in_characters' => 'anchorAllowWhiteSpaceInCharacters',
        'anchor_allow_white_space_in_characters_metadata' => 'anchorAllowWhiteSpaceInCharactersMetadata',
        'anchor_case_sensitive' => 'anchorCaseSensitive',
        'anchor_case_sensitive_metadata' => 'anchorCaseSensitiveMetadata',
        'anchor_horizontal_alignment' => 'anchorHorizontalAlignment',
        'anchor_horizontal_alignment_metadata' => 'anchorHorizontalAlignmentMetadata',
        'anchor_ignore_if_not_present' => 'anchorIgnoreIfNotPresent',
        'anchor_ignore_if_not_present_metadata' => 'anchorIgnoreIfNotPresentMetadata',
        'anchor_match_whole_word' => 'anchorMatchWholeWord',
        'anchor_match_whole_word_metadata' => 'anchorMatchWholeWordMetadata',
        'anchor_string' => 'anchorString',
        'anchor_string_metadata' => 'anchorStringMetadata',
        'anchor_tab_processor_version' => 'anchorTabProcessorVersion',
        'anchor_tab_processor_version_metadata' => 'anchorTabProcessorVersionMetadata',
        'anchor_units' => 'anchorUnits',
        'anchor_units_metadata' => 'anchorUnitsMetadata',
        'anchor_x_offset' => 'anchorXOffset',
        'anchor_x_offset_metadata' => 'anchorXOffsetMetadata',
        'anchor_y_offset' => 'anchorYOffset',
        'anchor_y_offset_metadata' => 'anchorYOffsetMetadata',
        'bold' => 'bold',
        'bold_metadata' => 'boldMetadata',
        'caption' => 'caption',
        'caption_metadata' => 'captionMetadata',
        'error_details' => 'errorDetails',
        'font' => 'font',
        'font_color' => 'fontColor',
        'font_color_metadata' => 'fontColorMetadata',
        'font_metadata' => 'fontMetadata',
        'font_size' => 'fontSize',
        'font_size_metadata' => 'fontSizeMetadata',
        'italic' => 'italic',
        'italic_metadata' => 'italicMetadata',
        'locked' => 'locked',
        'locked_metadata' => 'lockedMetadata',
        'merge_field_xml' => 'mergeFieldXml',
        'page_number' => 'pageNumber',
        'page_number_metadata' => 'pageNumberMetadata',
        'required' => 'required',
        'required_metadata' => 'requiredMetadata',
        'selected' => 'selected',
        'selected_metadata' => 'selectedMetadata',
        'status' => 'status',
        'status_metadata' => 'statusMetadata',
        'tab_id' => 'tabId',
        'tab_id_metadata' => 'tabIdMetadata',
        'tab_order' => 'tabOrder',
        'tab_order_metadata' => 'tabOrderMetadata',
        'underline' => 'underline',
        'underline_metadata' => 'underlineMetadata',
        'value' => 'value',
        'value_metadata' => 'valueMetadata',
        'x_position' => 'xPosition',
        'x_position_metadata' => 'xPositionMetadata',
        'y_position' => 'yPosition',
        'y_position_metadata' => 'yPositionMetadata'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'anchor_allow_white_space_in_characters' => 'setAnchorAllowWhiteSpaceInCharacters',
        'anchor_allow_white_space_in_characters_metadata' => 'setAnchorAllowWhiteSpaceInCharactersMetadata',
        'anchor_case_sensitive' => 'setAnchorCaseSensitive',
        'anchor_case_sensitive_metadata' => 'setAnchorCaseSensitiveMetadata',
        'anchor_horizontal_alignment' => 'setAnchorHorizontalAlignment',
        'anchor_horizontal_alignment_metadata' => 'setAnchorHorizontalAlignmentMetadata',
        'anchor_ignore_if_not_present' => 'setAnchorIgnoreIfNotPresent',
        'anchor_ignore_if_not_present_metadata' => 'setAnchorIgnoreIfNotPresentMetadata',
        'anchor_match_whole_word' => 'setAnchorMatchWholeWord',
        'anchor_match_whole_word_metadata' => 'setAnchorMatchWholeWordMetadata',
        'anchor_string' => 'setAnchorString',
        'anchor_string_metadata' => 'setAnchorStringMetadata',
        'anchor_tab_processor_version' => 'setAnchorTabProcessorVersion',
        'anchor_tab_processor_version_metadata' => 'setAnchorTabProcessorVersionMetadata',
        'anchor_units' => 'setAnchorUnits',
        'anchor_units_metadata' => 'setAnchorUnitsMetadata',
        'anchor_x_offset' => 'setAnchorXOffset',
        'anchor_x_offset_metadata' => 'setAnchorXOffsetMetadata',
        'anchor_y_offset' => 'setAnchorYOffset',
        'anchor_y_offset_metadata' => 'setAnchorYOffsetMetadata',
        'bold' => 'setBold',
        'bold_metadata' => 'setBoldMetadata',
        'caption' => 'setCaption',
        'caption_metadata' => 'setCaptionMetadata',
        'error_details' => 'setErrorDetails',
        'font' => 'setFont',
        'font_color' => 'setFontColor',
        'font_color_metadata' => 'setFontColorMetadata',
        'font_metadata' => 'setFontMetadata',
        'font_size' => 'setFontSize',
        'font_size_metadata' => 'setFontSizeMetadata',
        'italic' => 'setItalic',
        'italic_metadata' => 'setItalicMetadata',
        'locked' => 'setLocked',
        'locked_metadata' => 'setLockedMetadata',
        'merge_field_xml' => 'setMergeFieldXml',
        'page_number' => 'setPageNumber',
        'page_number_metadata' => 'setPageNumberMetadata',
        'required' => 'setRequired',
        'required_metadata' => 'setRequiredMetadata',
        'selected' => 'setSelected',
        'selected_metadata' => 'setSelectedMetadata',
        'status' => 'setStatus',
        'status_metadata' => 'setStatusMetadata',
        'tab_id' => 'setTabId',
        'tab_id_metadata' => 'setTabIdMetadata',
        'tab_order' => 'setTabOrder',
        'tab_order_metadata' => 'setTabOrderMetadata',
        'underline' => 'setUnderline',
        'underline_metadata' => 'setUnderlineMetadata',
        'value' => 'setValue',
        'value_metadata' => 'setValueMetadata',
        'x_position' => 'setXPosition',
        'x_position_metadata' => 'setXPositionMetadata',
        'y_position' => 'setYPosition',
        'y_position_metadata' => 'setYPositionMetadata'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'anchor_allow_white_space_in_characters' => 'getAnchorAllowWhiteSpaceInCharacters',
        'anchor_allow_white_space_in_characters_metadata' => 'getAnchorAllowWhiteSpaceInCharactersMetadata',
        'anchor_case_sensitive' => 'getAnchorCaseSensitive',
        'anchor_case_sensitive_metadata' => 'getAnchorCaseSensitiveMetadata',
        'anchor_horizontal_alignment' => 'getAnchorHorizontalAlignment',
        'anchor_horizontal_alignment_metadata' => 'getAnchorHorizontalAlignmentMetadata',
        'anchor_ignore_if_not_present' => 'getAnchorIgnoreIfNotPresent',
        'anchor_ignore_if_not_present_metadata' => 'getAnchorIgnoreIfNotPresentMetadata',
        'anchor_match_whole_word' => 'getAnchorMatchWholeWord',
        'anchor_match_whole_word_metadata' => 'getAnchorMatchWholeWordMetadata',
        'anchor_string' => 'getAnchorString',
        'anchor_string_metadata' => 'getAnchorStringMetadata',
        'anchor_tab_processor_version' => 'getAnchorTabProcessorVersion',
        'anchor_tab_processor_version_metadata' => 'getAnchorTabProcessorVersionMetadata',
        'anchor_units' => 'getAnchorUnits',
        'anchor_units_metadata' => 'getAnchorUnitsMetadata',
        'anchor_x_offset' => 'getAnchorXOffset',
        'anchor_x_offset_metadata' => 'getAnchorXOffsetMetadata',
        'anchor_y_offset' => 'getAnchorYOffset',
        'anchor_y_offset_metadata' => 'getAnchorYOffsetMetadata',
        'bold' => 'getBold',
        'bold_metadata' => 'getBoldMetadata',
        'caption' => 'getCaption',
        'caption_metadata' => 'getCaptionMetadata',
        'error_details' => 'getErrorDetails',
        'font' => 'getFont',
        'font_color' => 'getFontColor',
        'font_color_metadata' => 'getFontColorMetadata',
        'font_metadata' => 'getFontMetadata',
        'font_size' => 'getFontSize',
        'font_size_metadata' => 'getFontSizeMetadata',
        'italic' => 'getItalic',
        'italic_metadata' => 'getItalicMetadata',
        'locked' => 'getLocked',
        'locked_metadata' => 'getLockedMetadata',
        'merge_field_xml' => 'getMergeFieldXml',
        'page_number' => 'getPageNumber',
        'page_number_metadata' => 'getPageNumberMetadata',
        'required' => 'getRequired',
        'required_metadata' => 'getRequiredMetadata',
        'selected' => 'getSelected',
        'selected_metadata' => 'getSelectedMetadata',
        'status' => 'getStatus',
        'status_metadata' => 'getStatusMetadata',
        'tab_id' => 'getTabId',
        'tab_id_metadata' => 'getTabIdMetadata',
        'tab_order' => 'getTabOrder',
        'tab_order_metadata' => 'getTabOrderMetadata',
        'underline' => 'getUnderline',
        'underline_metadata' => 'getUnderlineMetadata',
        'value' => 'getValue',
        'value_metadata' => 'getValueMetadata',
        'x_position' => 'getXPosition',
        'x_position_metadata' => 'getXPositionMetadata',
        'y_position' => 'getYPosition',
        'y_position_metadata' => 'getYPositionMetadata'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['anchor_allow_white_space_in_characters'] = isset($data['anchor_allow_white_space_in_characters']) ? $data['anchor_allow_white_space_in_characters'] : null;
        $this->container['anchor_allow_white_space_in_characters_metadata'] = isset($data['anchor_allow_white_space_in_characters_metadata']) ? $data['anchor_allow_white_space_in_characters_metadata'] : null;
        $this->container['anchor_case_sensitive'] = isset($data['anchor_case_sensitive']) ? $data['anchor_case_sensitive'] : null;
        $this->container['anchor_case_sensitive_metadata'] = isset($data['anchor_case_sensitive_metadata']) ? $data['anchor_case_sensitive_metadata'] : null;
        $this->container['anchor_horizontal_alignment'] = isset($data['anchor_horizontal_alignment']) ? $data['anchor_horizontal_alignment'] : null;
        $this->container['anchor_horizontal_alignment_metadata'] = isset($data['anchor_horizontal_alignment_metadata']) ? $data['anchor_horizontal_alignment_metadata'] : null;
        $this->container['anchor_ignore_if_not_present'] = isset($data['anchor_ignore_if_not_present']) ? $data['anchor_ignore_if_not_present'] : null;
        $this->container['anchor_ignore_if_not_present_metadata'] = isset($data['anchor_ignore_if_not_present_metadata']) ? $data['anchor_ignore_if_not_present_metadata'] : null;
        $this->container['anchor_match_whole_word'] = isset($data['anchor_match_whole_word']) ? $data['anchor_match_whole_word'] : null;
        $this->container['anchor_match_whole_word_metadata'] = isset($data['anchor_match_whole_word_metadata']) ? $data['anchor_match_whole_word_metadata'] : null;
        $this->container['anchor_string'] = isset($data['anchor_string']) ? $data['anchor_string'] : null;
        $this->container['anchor_string_metadata'] = isset($data['anchor_string_metadata']) ? $data['anchor_string_metadata'] : null;
        $this->container['anchor_tab_processor_version'] = isset($data['anchor_tab_processor_version']) ? $data['anchor_tab_processor_version'] : null;
        $this->container['anchor_tab_processor_version_metadata'] = isset($data['anchor_tab_processor_version_metadata']) ? $data['anchor_tab_processor_version_metadata'] : null;
        $this->container['anchor_units'] = isset($data['anchor_units']) ? $data['anchor_units'] : null;
        $this->container['anchor_units_metadata'] = isset($data['anchor_units_metadata']) ? $data['anchor_units_metadata'] : null;
        $this->container['anchor_x_offset'] = isset($data['anchor_x_offset']) ? $data['anchor_x_offset'] : null;
        $this->container['anchor_x_offset_metadata'] = isset($data['anchor_x_offset_metadata']) ? $data['anchor_x_offset_metadata'] : null;
        $this->container['anchor_y_offset'] = isset($data['anchor_y_offset']) ? $data['anchor_y_offset'] : null;
        $this->container['anchor_y_offset_metadata'] = isset($data['anchor_y_offset_metadata']) ? $data['anchor_y_offset_metadata'] : null;
        $this->container['bold'] = isset($data['bold']) ? $data['bold'] : null;
        $this->container['bold_metadata'] = isset($data['bold_metadata']) ? $data['bold_metadata'] : null;
        $this->container['caption'] = isset($data['caption']) ? $data['caption'] : null;
        $this->container['caption_metadata'] = isset($data['caption_metadata']) ? $data['caption_metadata'] : null;
        $this->container['error_details'] = isset($data['error_details']) ? $data['error_details'] : null;
        $this->container['font'] = isset($data['font']) ? $data['font'] : null;
        $this->container['font_color'] = isset($data['font_color']) ? $data['font_color'] : null;
        $this->container['font_color_metadata'] = isset($data['font_color_metadata']) ? $data['font_color_metadata'] : null;
        $this->container['font_metadata'] = isset($data['font_metadata']) ? $data['font_metadata'] : null;
        $this->container['font_size'] = isset($data['font_size']) ? $data['font_size'] : null;
        $this->container['font_size_metadata'] = isset($data['font_size_metadata']) ? $data['font_size_metadata'] : null;
        $this->container['italic'] = isset($data['italic']) ? $data['italic'] : null;
        $this->container['italic_metadata'] = isset($data['italic_metadata']) ? $data['italic_metadata'] : null;
        $this->container['locked'] = isset($data['locked']) ? $data['locked'] : null;
        $this->container['locked_metadata'] = isset($data['locked_metadata']) ? $data['locked_metadata'] : null;
        $this->container['merge_field_xml'] = isset($data['merge_field_xml']) ? $data['merge_field_xml'] : null;
        $this->container['page_number'] = isset($data['page_number']) ? $data['page_number'] : null;
        $this->container['page_number_metadata'] = isset($data['page_number_metadata']) ? $data['page_number_metadata'] : null;
        $this->container['required'] = isset($data['required']) ? $data['required'] : null;
        $this->container['required_metadata'] = isset($data['required_metadata']) ? $data['required_metadata'] : null;
        $this->container['selected'] = isset($data['selected']) ? $data['selected'] : null;
        $this->container['selected_metadata'] = isset($data['selected_metadata']) ? $data['selected_metadata'] : null;
        $this->container['status'] = isset($data['status']) ? $data['status'] : null;
        $this->container['status_metadata'] = isset($data['status_metadata']) ? $data['status_metadata'] : null;
        $this->container['tab_id'] = isset($data['tab_id']) ? $data['tab_id'] : null;
        $this->container['tab_id_metadata'] = isset($data['tab_id_metadata']) ? $data['tab_id_metadata'] : null;
        $this->container['tab_order'] = isset($data['tab_order']) ? $data['tab_order'] : null;
        $this->container['tab_order_metadata'] = isset($data['tab_order_metadata']) ? $data['tab_order_metadata'] : null;
        $this->container['underline'] = isset($data['underline']) ? $data['underline'] : null;
        $this->container['underline_metadata'] = isset($data['underline_metadata']) ? $data['underline_metadata'] : null;
        $this->container['value'] = isset($data['value']) ? $data['value'] : null;
        $this->container['value_metadata'] = isset($data['value_metadata']) ? $data['value_metadata'] : null;
        $this->container['x_position'] = isset($data['x_position']) ? $data['x_position'] : null;
        $this->container['x_position_metadata'] = isset($data['x_position_metadata']) ? $data['x_position_metadata'] : null;
        $this->container['y_position'] = isset($data['y_position']) ? $data['y_position'] : null;
        $this->container['y_position_metadata'] = isset($data['y_position_metadata']) ? $data['y_position_metadata'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets anchor_allow_white_space_in_characters
     *
     * @return ?string
     */
    public function getAnchorAllowWhiteSpaceInCharacters()
    {
        return $this->container['anchor_allow_white_space_in_characters'];
    }

    /**
     * Sets anchor_allow_white_space_in_characters
     *
     * @param ?string $anchor_allow_white_space_in_characters 
     *
     * @return $this
     */
    public function setAnchorAllowWhiteSpaceInCharacters($anchor_allow_white_space_in_characters)
    {
        $this->container['anchor_allow_white_space_in_characters'] = $anchor_allow_white_space_in_characters;

        return $this;
    }

    /**
     * Gets anchor_allow_white_space_in_characters_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getAnchorAllowWhiteSpaceInCharactersMetadata()
    {
        return $this->container['anchor_allow_white_space_in_characters_metadata'];
    }

    /**
     * Sets anchor_allow_white_space_in_characters_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $anchor_allow_white_space_in_characters_metadata Metadata that indicates whether the `anchorAllowWhiteSpaceInCharacters` property is editable.
     *
     * @return $this
     */
    public function setAnchorAllowWhiteSpaceInCharactersMetadata($anchor_allow_white_space_in_characters_metadata)
    {
        $this->container['anchor_allow_white_space_in_characters_metadata'] = $anchor_allow_white_space_in_characters_metadata;

        return $this;
    }

    /**
     * Gets anchor_case_sensitive
     *
     * @return ?string
     */
    public function getAnchorCaseSensitive()
    {
        return $this->container['anchor_case_sensitive'];
    }

    /**
     * Sets anchor_case_sensitive
     *
     * @param ?string $anchor_case_sensitive When set to **true**, the anchor string does not consider case when matching strings in the document. The default value is **true**.
     *
     * @return $this
     */
    public function setAnchorCaseSensitive($anchor_case_sensitive)
    {
        $this->container['anchor_case_sensitive'] = $anchor_case_sensitive;

        return $this;
    }

    /**
     * Gets anchor_case_sensitive_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getAnchorCaseSensitiveMetadata()
    {
        return $this->container['anchor_case_sensitive_metadata'];
    }

    /**
     * Sets anchor_case_sensitive_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $anchor_case_sensitive_metadata Metadata that indicates whether the `anchorCaseSensitive` property is editable.
     *
     * @return $this
     */
    public function setAnchorCaseSensitiveMetadata($anchor_case_sensitive_metadata)
    {
        $this->container['anchor_case_sensitive_metadata'] = $anchor_case_sensitive_metadata;

        return $this;
    }

    /**
     * Gets anchor_horizontal_alignment
     *
     * @return ?string
     */
    public function getAnchorHorizontalAlignment()
    {
        return $this->container['anchor_horizontal_alignment'];
    }

    /**
     * Sets anchor_horizontal_alignment
     *
     * @param ?string $anchor_horizontal_alignment Specifies the alignment of anchor tabs with anchor strings. Possible values are **left** or **right**. The default value is **left**.
     *
     * @return $this
     */
    public function setAnchorHorizontalAlignment($anchor_horizontal_alignment)
    {
        $this->container['anchor_horizontal_alignment'] = $anchor_horizontal_alignment;

        return $this;
    }

    /**
     * Gets anchor_horizontal_alignment_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getAnchorHorizontalAlignmentMetadata()
    {
        return $this->container['anchor_horizontal_alignment_metadata'];
    }

    /**
     * Sets anchor_horizontal_alignment_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $anchor_horizontal_alignment_metadata Metadata that indicates whether the `anchorHorizontalAlignment` property is editable.
     *
     * @return $this
     */
    public function setAnchorHorizontalAlignmentMetadata($anchor_horizontal_alignment_metadata)
    {
        $this->container['anchor_horizontal_alignment_metadata'] = $anchor_horizontal_alignment_metadata;

        return $this;
    }

    /**
     * Gets anchor_ignore_if_not_present
     *
     * @return ?string
     */
    public function getAnchorIgnoreIfNotPresent()
    {
        return $this->container['anchor_ignore_if_not_present'];
    }

    /**
     * Sets anchor_ignore_if_not_present
     *
     * @param ?string $anchor_ignore_if_not_present When set to **true**, this tab is ignored if anchorString is not found in the document.
     *
     * @return $this
     */
    public function setAnchorIgnoreIfNotPresent($anchor_ignore_if_not_present)
    {
        $this->container['anchor_ignore_if_not_present'] = $anchor_ignore_if_not_present;

        return $this;
    }

    /**
     * Gets anchor_ignore_if_not_present_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getAnchorIgnoreIfNotPresentMetadata()
    {
        return $this->container['anchor_ignore_if_not_present_metadata'];
    }

    /**
     * Sets anchor_ignore_if_not_present_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $anchor_ignore_if_not_present_metadata Metadata that indicates whether the `anchorIgnoreIfNotPresent` property is editable.
     *
     * @return $this
     */
    public function setAnchorIgnoreIfNotPresentMetadata($anchor_ignore_if_not_present_metadata)
    {
        $this->container['anchor_ignore_if_not_present_metadata'] = $anchor_ignore_if_not_present_metadata;

        return $this;
    }

    /**
     * Gets anchor_match_whole_word
     *
     * @return ?string
     */
    public function getAnchorMatchWholeWord()
    {
        return $this->container['anchor_match_whole_word'];
    }

    /**
     * Sets anchor_match_whole_word
     *
     * @param ?string $anchor_match_whole_word When set to **true**, the anchor string in this tab matches whole words only (strings embedded in other strings are ignored.) The default value is **true**.
     *
     * @return $this
     */
    public function setAnchorMatchWholeWord($anchor_match_whole_word)
    {
        $this->container['anchor_match_whole_word'] = $anchor_match_whole_word;

        return $this;
    }

    /**
     * Gets anchor_match_whole_word_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getAnchorMatchWholeWordMetadata()
    {
        return $this->container['anchor_match_whole_word_metadata'];
    }

    /**
     * Sets anchor_match_whole_word_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $anchor_match_whole_word_metadata Metadata that indicates whether the `anchorMatchWholeWord` property is editable.
     *
     * @return $this
     */
    public function setAnchorMatchWholeWordMetadata($anchor_match_whole_word_metadata)
    {
        $this->container['anchor_match_whole_word_metadata'] = $anchor_match_whole_word_metadata;

        return $this;
    }

    /**
     * Gets anchor_string
     *
     * @return ?string
     */
    public function getAnchorString()
    {
        return $this->container['anchor_string'];
    }

    /**
     * Sets anchor_string
     *
     * @param ?string $anchor_string Anchor text information for a radio button.
     *
     * @return $this
     */
    public function setAnchorString($anchor_string)
    {
        $this->container['anchor_string'] = $anchor_string;

        return $this;
    }

    /**
     * Gets anchor_string_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getAnchorStringMetadata()
    {
        return $this->container['anchor_string_metadata'];
    }

    /**
     * Sets anchor_string_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $anchor_string_metadata Metadata that indicates whether the `anchorString` property is editable.
     *
     * @return $this
     */
    public function setAnchorStringMetadata($anchor_string_metadata)
    {
        $this->container['anchor_string_metadata'] = $anchor_string_metadata;

        return $this;
    }

    /**
     * Gets anchor_tab_processor_version
     *
     * @return ?string
     */
    public function getAnchorTabProcessorVersion()
    {
        return $this->container['anchor_tab_processor_version'];
    }

    /**
     * Sets anchor_tab_processor_version
     *
     * @param ?string $anchor_tab_processor_version 
     *
     * @return $this
     */
    public function setAnchorTabProcessorVersion($anchor_tab_processor_version)
    {
        $this->container['anchor_tab_processor_version'] = $anchor_tab_processor_version;

        return $this;
    }

    /**
     * Gets anchor_tab_processor_version_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getAnchorTabProcessorVersionMetadata()
    {
        return $this->container['anchor_tab_processor_version_metadata'];
    }

    /**
     * Sets anchor_tab_processor_version_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $anchor_tab_processor_version_metadata Reserved for DocuSign.
     *
     * @return $this
     */
    public function setAnchorTabProcessorVersionMetadata($anchor_tab_processor_version_metadata)
    {
        $this->container['anchor_tab_processor_version_metadata'] = $anchor_tab_processor_version_metadata;

        return $this;
    }

    /**
     * Gets anchor_units
     *
     * @return ?string
     */
    public function getAnchorUnits()
    {
        return $this->container['anchor_units'];
    }

    /**
     * Sets anchor_units
     *
     * @param ?string $anchor_units Specifies units of the X and Y offset. Units could be pixels, millimeters, centimeters, or inches.
     *
     * @return $this
     */
    public function setAnchorUnits($anchor_units)
    {
        $this->container['anchor_units'] = $anchor_units;

        return $this;
    }

    /**
     * Gets anchor_units_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getAnchorUnitsMetadata()
    {
        return $this->container['anchor_units_metadata'];
    }

    /**
     * Sets anchor_units_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $anchor_units_metadata Metadata that indicates whether the `anchorUnits` property is editable.
     *
     * @return $this
     */
    public function setAnchorUnitsMetadata($anchor_units_metadata)
    {
        $this->container['anchor_units_metadata'] = $anchor_units_metadata;

        return $this;
    }

    /**
     * Gets anchor_x_offset
     *
     * @return ?string
     */
    public function getAnchorXOffset()
    {
        return $this->container['anchor_x_offset'];
    }

    /**
     * Sets anchor_x_offset
     *
     * @param ?string $anchor_x_offset Specifies the X axis location of the tab, in anchorUnits, relative to the anchorString.
     *
     * @return $this
     */
    public function setAnchorXOffset($anchor_x_offset)
    {
        $this->container['anchor_x_offset'] = $anchor_x_offset;

        return $this;
    }

    /**
     * Gets anchor_x_offset_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getAnchorXOffsetMetadata()
    {
        return $this->container['anchor_x_offset_metadata'];
    }

    /**
     * Sets anchor_x_offset_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $anchor_x_offset_metadata Metadata that indicates whether the `anchorXOffset` property is editable.
     *
     * @return $this
     */
    public function setAnchorXOffsetMetadata($anchor_x_offset_metadata)
    {
        $this->container['anchor_x_offset_metadata'] = $anchor_x_offset_metadata;

        return $this;
    }

    /**
     * Gets anchor_y_offset
     *
     * @return ?string
     */
    public function getAnchorYOffset()
    {
        return $this->container['anchor_y_offset'];
    }

    /**
     * Sets anchor_y_offset
     *
     * @param ?string $anchor_y_offset Specifies the Y axis location of the tab, in anchorUnits, relative to the anchorString.
     *
     * @return $this
     */
    public function setAnchorYOffset($anchor_y_offset)
    {
        $this->container['anchor_y_offset'] = $anchor_y_offset;

        return $this;
    }

    /**
     * Gets anchor_y_offset_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getAnchorYOffsetMetadata()
    {
        return $this->container['anchor_y_offset_metadata'];
    }

    /**
     * Sets anchor_y_offset_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $anchor_y_offset_metadata Metadata that indicates whether the `anchorYOffset` property is editable.
     *
     * @return $this
     */
    public function setAnchorYOffsetMetadata($anchor_y_offset_metadata)
    {
        $this->container['anchor_y_offset_metadata'] = $anchor_y_offset_metadata;

        return $this;
    }

    /**
     * Gets bold
     *
     * @return ?string
     */
    public function getBold()
    {
        return $this->container['bold'];
    }

    /**
     * Sets bold
     *
     * @param ?string $bold When set to **true**, the information in the tab is bold.
     *
     * @return $this
     */
    public function setBold($bold)
    {
        $this->container['bold'] = $bold;

        return $this;
    }

    /**
     * Gets bold_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getBoldMetadata()
    {
        return $this->container['bold_metadata'];
    }

    /**
     * Sets bold_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $bold_metadata Metadata that indicates whether the `bold` property is editable.
     *
     * @return $this
     */
    public function setBoldMetadata($bold_metadata)
    {
        $this->container['bold_metadata'] = $bold_metadata;

        return $this;
    }

    /**
     * Gets caption
     *
     * @return ?string
     */
    public function getCaption()
    {
        return $this->container['caption'];
    }

    /**
     * Sets caption
     *
     * @param ?string $caption 
     *
     * @return $this
     */
    public function setCaption($caption)
    {
        $this->container['caption'] = $caption;

        return $this;
    }

    /**
     * Gets caption_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getCaptionMetadata()
    {
        return $this->container['caption_metadata'];
    }

    /**
     * Sets caption_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $caption_metadata 
     *
     * @return $this
     */
    public function setCaptionMetadata($caption_metadata)
    {
        $this->container['caption_metadata'] = $caption_metadata;

        return $this;
    }

    /**
     * Gets error_details
     *
     * @return \DocuSign\eSign\Model\ErrorDetails
     */
    public function getErrorDetails()
    {
        return $this->container['error_details'];
    }

    /**
     * Sets error_details
     *
     * @param \DocuSign\eSign\Model\ErrorDetails $error_details Array or errors.
     *
     * @return $this
     */
    public function setErrorDetails($error_details)
    {
        $this->container['error_details'] = $error_details;

        return $this;
    }

    /**
     * Gets font
     *
     * @return ?string
     */
    public function getFont()
    {
        return $this->container['font'];
    }

    /**
     * Sets font
     *
     * @param ?string $font The font to be used for the tab value. Supported Fonts: Arial, Arial, ArialNarrow, Calibri, CourierNew, Garamond, Georgia, Helvetica,   LucidaConsole, Tahoma, TimesNewRoman, Trebuchet, Verdana, MSGothic, MSMincho, Default.
     *
     * @return $this
     */
    public function setFont($font)
    {
        $this->container['font'] = $font;

        return $this;
    }

    /**
     * Gets font_color
     *
     * @return ?string
     */
    public function getFontColor()
    {
        return $this->container['font_color'];
    }

    /**
     * Sets font_color
     *
     * @param ?string $font_color The font color used for the information in the tab.  Possible values are: Black, BrightBlue, BrightRed, DarkGreen, DarkRed, Gold, Green, NavyBlue, Purple, or White.
     *
     * @return $this
     */
    public function setFontColor($font_color)
    {
        $this->container['font_color'] = $font_color;

        return $this;
    }

    /**
     * Gets font_color_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getFontColorMetadata()
    {
        return $this->container['font_color_metadata'];
    }

    /**
     * Sets font_color_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $font_color_metadata Metadata that indicates whether the `fontColor` property is editable.
     *
     * @return $this
     */
    public function setFontColorMetadata($font_color_metadata)
    {
        $this->container['font_color_metadata'] = $font_color_metadata;

        return $this;
    }

    /**
     * Gets font_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getFontMetadata()
    {
        return $this->container['font_metadata'];
    }

    /**
     * Sets font_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $font_metadata Metadata that indicates whether the `font` property is editable.
     *
     * @return $this
     */
    public function setFontMetadata($font_metadata)
    {
        $this->container['font_metadata'] = $font_metadata;

        return $this;
    }

    /**
     * Gets font_size
     *
     * @return ?string
     */
    public function getFontSize()
    {
        return $this->container['font_size'];
    }

    /**
     * Sets font_size
     *
     * @param ?string $font_size The font size used for the information in the tab.  Possible values are: Size7, Size8, Size9, Size10, Size11, Size12, Size14, Size16, Size18, Size20, Size22, Size24, Size26, Size28, Size36, Size48, or Size72.
     *
     * @return $this
     */
    public function setFontSize($font_size)
    {
        $this->container['font_size'] = $font_size;

        return $this;
    }

    /**
     * Gets font_size_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getFontSizeMetadata()
    {
        return $this->container['font_size_metadata'];
    }

    /**
     * Sets font_size_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $font_size_metadata Metadata that indicates whether the `fontSize` property is editable.
     *
     * @return $this
     */
    public function setFontSizeMetadata($font_size_metadata)
    {
        $this->container['font_size_metadata'] = $font_size_metadata;

        return $this;
    }

    /**
     * Gets italic
     *
     * @return ?string
     */
    public function getItalic()
    {
        return $this->container['italic'];
    }

    /**
     * Sets italic
     *
     * @param ?string $italic When set to **true**, the information in the tab is italic.
     *
     * @return $this
     */
    public function setItalic($italic)
    {
        $this->container['italic'] = $italic;

        return $this;
    }

    /**
     * Gets italic_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getItalicMetadata()
    {
        return $this->container['italic_metadata'];
    }

    /**
     * Sets italic_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $italic_metadata Metadata that indicates whether the `italic` property is editable.
     *
     * @return $this
     */
    public function setItalicMetadata($italic_metadata)
    {
        $this->container['italic_metadata'] = $italic_metadata;

        return $this;
    }

    /**
     * Gets locked
     *
     * @return ?string
     */
    public function getLocked()
    {
        return $this->container['locked'];
    }

    /**
     * Sets locked
     *
     * @param ?string $locked When set to **true**, the signer cannot change the data of the custom tab.
     *
     * @return $this
     */
    public function setLocked($locked)
    {
        $this->container['locked'] = $locked;

        return $this;
    }

    /**
     * Gets locked_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getLockedMetadata()
    {
        return $this->container['locked_metadata'];
    }

    /**
     * Sets locked_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $locked_metadata Metadata that indicates whether the `locked` property is editable.
     *
     * @return $this
     */
    public function setLockedMetadata($locked_metadata)
    {
        $this->container['locked_metadata'] = $locked_metadata;

        return $this;
    }

    /**
     * Gets merge_field_xml
     *
     * @return ?string
     */
    public function getMergeFieldXml()
    {
        return $this->container['merge_field_xml'];
    }

    /**
     * Sets merge_field_xml
     *
     * @param ?string $merge_field_xml 
     *
     * @return $this
     */
    public function setMergeFieldXml($merge_field_xml)
    {
        $this->container['merge_field_xml'] = $merge_field_xml;

        return $this;
    }

    /**
     * Gets page_number
     *
     * @return ?string
     */
    public function getPageNumber()
    {
        return $this->container['page_number'];
    }

    /**
     * Sets page_number
     *
     * @param ?string $page_number Specifies the page number on which the tab is located.
     *
     * @return $this
     */
    public function setPageNumber($page_number)
    {
        $this->container['page_number'] = $page_number;

        return $this;
    }

    /**
     * Gets page_number_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getPageNumberMetadata()
    {
        return $this->container['page_number_metadata'];
    }

    /**
     * Sets page_number_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $page_number_metadata Metadata that indicates whether the `pageNumber` property is editable.
     *
     * @return $this
     */
    public function setPageNumberMetadata($page_number_metadata)
    {
        $this->container['page_number_metadata'] = $page_number_metadata;

        return $this;
    }

    /**
     * Gets required
     *
     * @return ?string
     */
    public function getRequired()
    {
        return $this->container['required'];
    }

    /**
     * Sets required
     *
     * @param ?string $required When set to **true**, the signer is required to fill out this tab
     *
     * @return $this
     */
    public function setRequired($required)
    {
        $this->container['required'] = $required;

        return $this;
    }

    /**
     * Gets required_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getRequiredMetadata()
    {
        return $this->container['required_metadata'];
    }

    /**
     * Sets required_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $required_metadata Metadata that indicates whether the `required` property is editable.
     *
     * @return $this
     */
    public function setRequiredMetadata($required_metadata)
    {
        $this->container['required_metadata'] = $required_metadata;

        return $this;
    }

    /**
     * Gets selected
     *
     * @return ?string
     */
    public function getSelected()
    {
        return $this->container['selected'];
    }

    /**
     * Sets selected
     *
     * @param ?string $selected When set to **true**, the radio button is selected.
     *
     * @return $this
     */
    public function setSelected($selected)
    {
        $this->container['selected'] = $selected;

        return $this;
    }

    /**
     * Gets selected_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getSelectedMetadata()
    {
        return $this->container['selected_metadata'];
    }

    /**
     * Sets selected_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $selected_metadata Metadata that indicates whether the `selected` property is editable.
     *
     * @return $this
     */
    public function setSelectedMetadata($selected_metadata)
    {
        $this->container['selected_metadata'] = $selected_metadata;

        return $this;
    }

    /**
     * Gets status
     *
     * @return ?string
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param ?string $status Indicates the envelope status. Valid values are:  * sent - The envelope is sent to the recipients.  * created - The envelope is saved as a draft and can be modified and sent later.
     *
     * @return $this
     */
    public function setStatus($status)
    {
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets status_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getStatusMetadata()
    {
        return $this->container['status_metadata'];
    }

    /**
     * Sets status_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $status_metadata Metadata that indicates whether the `status` property is editable.
     *
     * @return $this
     */
    public function setStatusMetadata($status_metadata)
    {
        $this->container['status_metadata'] = $status_metadata;

        return $this;
    }

    /**
     * Gets tab_id
     *
     * @return ?string
     */
    public function getTabId()
    {
        return $this->container['tab_id'];
    }

    /**
     * Sets tab_id
     *
     * @param ?string $tab_id The unique identifier for the tab. The tabid can be retrieved with the [ML:GET call].
     *
     * @return $this
     */
    public function setTabId($tab_id)
    {
        $this->container['tab_id'] = $tab_id;

        return $this;
    }

    /**
     * Gets tab_id_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getTabIdMetadata()
    {
        return $this->container['tab_id_metadata'];
    }

    /**
     * Sets tab_id_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $tab_id_metadata Metadata that indicates whether the `tabId` property is editable.
     *
     * @return $this
     */
    public function setTabIdMetadata($tab_id_metadata)
    {
        $this->container['tab_id_metadata'] = $tab_id_metadata;

        return $this;
    }

    /**
     * Gets tab_order
     *
     * @return ?string
     */
    public function getTabOrder()
    {
        return $this->container['tab_order'];
    }

    /**
     * Sets tab_order
     *
     * @param ?string $tab_order 
     *
     * @return $this
     */
    public function setTabOrder($tab_order)
    {
        $this->container['tab_order'] = $tab_order;

        return $this;
    }

    /**
     * Gets tab_order_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getTabOrderMetadata()
    {
        return $this->container['tab_order_metadata'];
    }

    /**
     * Sets tab_order_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $tab_order_metadata Metadata that indicates whether the `tabOrder` property is editable.
     *
     * @return $this
     */
    public function setTabOrderMetadata($tab_order_metadata)
    {
        $this->container['tab_order_metadata'] = $tab_order_metadata;

        return $this;
    }

    /**
     * Gets underline
     *
     * @return ?string
     */
    public function getUnderline()
    {
        return $this->container['underline'];
    }

    /**
     * Sets underline
     *
     * @param ?string $underline When set to **true**, the information in the tab is underlined.
     *
     * @return $this
     */
    public function setUnderline($underline)
    {
        $this->container['underline'] = $underline;

        return $this;
    }

    /**
     * Gets underline_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getUnderlineMetadata()
    {
        return $this->container['underline_metadata'];
    }

    /**
     * Sets underline_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $underline_metadata Metadata that indicates whether the `underline` property is editable.
     *
     * @return $this
     */
    public function setUnderlineMetadata($underline_metadata)
    {
        $this->container['underline_metadata'] = $underline_metadata;

        return $this;
    }

    /**
     * Gets value
     *
     * @return ?string
     */
    public function getValue()
    {
        return $this->container['value'];
    }

    /**
     * Sets value
     *
     * @param ?string $value Specifies the value of the tab.
     *
     * @return $this
     */
    public function setValue($value)
    {
        $this->container['value'] = $value;

        return $this;
    }

    /**
     * Gets value_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getValueMetadata()
    {
        return $this->container['value_metadata'];
    }

    /**
     * Sets value_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $value_metadata Metadata that indicates whether the `value` property is editable.
     *
     * @return $this
     */
    public function setValueMetadata($value_metadata)
    {
        $this->container['value_metadata'] = $value_metadata;

        return $this;
    }

    /**
     * Gets x_position
     *
     * @return ?string
     */
    public function getXPosition()
    {
        return $this->container['x_position'];
    }

    /**
     * Sets x_position
     *
     * @param ?string $x_position This indicates the horizontal offset of the object on the page. DocuSign uses 72 DPI when determining position.
     *
     * @return $this
     */
    public function setXPosition($x_position)
    {
        $this->container['x_position'] = $x_position;

        return $this;
    }

    /**
     * Gets x_position_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getXPositionMetadata()
    {
        return $this->container['x_position_metadata'];
    }

    /**
     * Sets x_position_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $x_position_metadata Metadata that indicates whether the `xPosition` property is editable.
     *
     * @return $this
     */
    public function setXPositionMetadata($x_position_metadata)
    {
        $this->container['x_position_metadata'] = $x_position_metadata;

        return $this;
    }

    /**
     * Gets y_position
     *
     * @return ?string
     */
    public function getYPosition()
    {
        return $this->container['y_position'];
    }

    /**
     * Sets y_position
     *
     * @param ?string $y_position This indicates the vertical offset of the object on the page. DocuSign uses 72 DPI when determining position.
     *
     * @return $this
     */
    public function setYPosition($y_position)
    {
        $this->container['y_position'] = $y_position;

        return $this;
    }

    /**
     * Gets y_position_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getYPositionMetadata()
    {
        return $this->container['y_position_metadata'];
    }

    /**
     * Sets y_position_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $y_position_metadata Metadata that indicates whether the `yPosition` property is editable.
     *
     * @return $this
     */
    public function setYPositionMetadata($y_position_metadata)
    {
        $this->container['y_position_metadata'] = $y_position_metadata;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}

